theory question_81_3
imports Main
begin

typedecl entity
typedecl event

consts
  Bicycle :: "entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  WithBike :: "entity ⇒ bool"
  On :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  Soaring :: "event ⇒ bool"
  Wears :: "event ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Lake :: "entity ⇒ bool"

(* Explanation 1: Riding a bicycle outdoors implies the person is outside. *)
axiomatization where
  explanation_1: "∀x y e. Bicycle y ∧ Outdoors x ∧ Riding e ∧ Agent e x ∧ Patient e y ⟶ Outside x"

(* Explanation 2: Being on a bicycle indicates the person is with a bike. *)
axiomatization where
  explanation_2: "∀x y e. Bicycle y ∧ Person x ∧ On e ∧ Agent e x ∧ Patient e y ⟶ WithBike x"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Jumps e1 ∧ Soaring e2 ∧ Wears e3 ∧ On e1 ∧ On e2 ∧ On e3 ∧ Agent e1 x ∧ Agent e2 x ∧ Agent e3 x ∧ Patient e3 z ∧ InFrontOf x Skyline ∧ InFrontOf x Lake"
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y. Person x ∧ Outside x ∧ WithBike x"
proof -
  from asm have "Person x ∧ Bicycle y" by blast
  then have "Outside x" using explanation_1 by blast
  then have "WithBike x" using explanation_2 by blast
  then show ?thesis using `Person x` `Outside x` `WithBike x` by blast
qed

end
