theory question_81_2

imports Main

begin
typedecl entity
typedecl event

consts
  Bicycle :: "entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  Soaring :: "event ⇒ bool"
  OverTheGround :: "event ⇒ bool"
  Involve :: "event ⇒ entity ⇒ bool"
  Ride :: "event ⇒ bool"
  Imply :: "event ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Bike :: "entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Lake :: "entity ⇒ bool"

(* Explanation 1: Riding a bicycle outdoors involves soaring over the ground. *)
axiomatization where
  explanation_1: "∃x y e. Bicycle y ∧ Outdoors x ∧ Soaring e ∧ OverTheGround e ∧ Involve e x ∧ Involve e y"

(* Explanation 2: Soaring over the ground while riding a bicycle implies the person is outside. *)
axiomatization where
  explanation_2: "∀x y e. Bicycle y ∧ Soaring e ∧ OverTheGround e ∧ Ride e ∧ Imply e x ⟶ Outside x"

(* Explanation 3: Being on a bicycle indicates the person is outdoors. *)
axiomatization where
  explanation_3: "∀x y. Bicycle y ∧ On x y ⟶ Outside x"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Jumps e1 ∧ Soaring e2 ∧ OverTheGround e2 ∧ InFrontOf x skyline ∧ InFrontOf x lake ∧ InFrontOf x z"
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y. Person x ∧ Bike y ∧ Outside x"
proof -
  from asm have "Person x ∧ Bicycle y ∧ Soaring e2 ∧ OverTheGround e2" by blast
  then have "Outside x" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
