# Fairness-Aware Online Positive-Unlabeled Learning

## Data Preparation
```
cd nlp
python wiki_prepprocessing.py
```
It will automatically download Wiki Toxicity dataset, and split it into training, validation, and test subsets. 

## Training
Run ```python main.py --model MODEL --dataset DATASET --r1 R1 --batch_size BATCH_SIZE --epoch EPOCH --pu_type PU_TYPE --lr LR --round ROUND --fairness FAIRNESS_CONSTRAINT --online --fair --lam_f LAMBDA_F --penalty --lam_penalty LAMBDA_PENALTY```

#### Options
- MODEL: ```mlp```, ```linear```, and ```lstm```.
- DATASET: ```wiki```, ```chat_toxicity```, and ```nela```.
- R1: the ratio of unlabeled samples in positive instances.($\gamma_u$ in the paper.)
- BATCH_SIZE: the batch size for offline learning. The batch size will be set as a full batch in online learning.
- EPOCH: the number of epochs for offline learning. The number of epochs will be set as 1 in online learning.
- PU_TYPE: ```upu``` and ```nnpu```.
- LR: ```lr=0.001``` is recommended for offline learning. ```lr=1.0``` for MLP and linear, and ```lr=100``` for LSTM are recommended for online learning.
- ROUND: The number of total rounds for online learning.
- FAIRNESS_CONSTRAINT: fairness constraint to compute a fairness loss. ```ddp``` and ```deo``.
- LAMBDA_F: a hyperparameter to weigh the fairness loss.
- ONLINE: command ```--online``` to run online learning. To execute offline learning, drop this command.
- FAIR: command ```--fair``` to use fairness loss. To execute the baseline, drop this command.
- PENALTY: command ```--penalty``` to use penalty term in the fair loss term.
- LAMBDA_PENALTY: a hyperparameter to weigh the penalty term. Recommened the same scale with LAMBDA_F.

#### Example
##### Offline
```python main.py --dataset wiki  --model linear --pu_type nnpu --gpu_id 0 --lr 0.01 --r1 0.5 --fair --fairness deo --lam_f 0.01 --penalty --lam_penalty 0.001```
##### Online 
```python main.py --dataset wiki --online --model linear --pu_type nnpu --gpu_id 0 --lr 1 --r1 0.5 --fair --fairness deo --lam_f 0.01 --penalty --lam_penalty 0.001```

