# Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.  
# SPDX-License-Identifier: CC-BY-NC-4.0
import json
from typing import Iterable

from da4er.utils import InputConverter, Sample, AugmentedSamples, InputSample, OutputConverter


class BlinkInputConverter(InputConverter):
    def process(self, raw_input: str) -> InputSample:
        processed_input = json.loads(raw_input)
        original_sample = Sample(processed_input["mention"], [processed_input["label_title"]])
        augmented_sample = AugmentedSamples(original_sample, [])
        return InputSample(processed_input, augmented_sample)


class BlinkOutputConverter(OutputConverter):
    def generate_output(self, input_sample: InputSample) -> Iterable[str]:
        for augmented_sample in input_sample.work_sample.augmented:
            # This format only supports one entity per sample
            assert len(augmented_sample.entities) == 1

            # Note that we will only modify in place the top level attributes, so it's okay to copy it in this way
            #   normally you should do a deep copy here or construct a new sample from the ground up
            new_sample = dict(input_sample.raw_input)
            new_sample["mention"] = augmented_sample.query
            new_sample["label_title"] = augmented_sample.entities[0]
            yield json.dumps(new_sample)
