# 8월 버전입니다. 추후 사용할 때 수정할 예정입니다.
def replace_null(column: NumColumn) -> NumColumn:
    # res_column = NumColumn(column.context, num_rows=column.num_rows,
    #     encrypted=column.encrypted, name=f"({column.name}.rpnull)", type=ColType.NUM_NONE)
    # res_column.data = column.data

    res_column = column.copy(dst_parent_path="./stat_test")
    if not column.has_vbit:
        return res_column  # Return right away if there are no vbits to begin with

    for block in res_column.vbit:
        block *= 0
        block += Block.ones(column.context)

    block_replace = average(column)

    for res_block, vbit_block in zip(res_column.data, column.vbit):
        inv_vbit_block = Block.ones(column.context, encrypted=True)
        inv_vbit_block -= vbit_block
        res_block += block_replace * inv_vbit_block

    return res_column


def remove_outliers(column: NumColumn) -> NumColumn:
    norm_column = column.normalize(type=NormType.ZERO_ONE)
    # res_column = NumColumn(column.context, num_rows=column.num_rows, encrypted=column.encrypted, name=f"({column.name}.rmout)")
    # res_column.data = column.data
    # print("HELLO")
    # if column.has_vbit:
    #     res_column.vbit = column.vbit
    # else:
    #     return res_column
    #
    # #only proceed when input column has vbit
    # norm_column: used for calculations
    # res_column: column to be returned

    res_column = column.copy(dst_parent_path="./stat_test")

    block_sum = sum(norm_column)
    block_count = count(column)
    block_count_minus = block_count - 1
    block_count_inv = __safe_inverse(block_count, column.num_rows)
    block_avg = block_sum * block_count_inv

    block_var = Block.zeros(column.context, encrypted=True)
    if column.has_vbit():
        for data_block, vbit_block in zip(norm_column.data, norm_column.vbit):
            tmp = data_block - block_avg
            tmp *= vbit_block
            tmp *= tmp
            block_var += tmp

    block_var = __rotate_sum(block_var)
    block_count_minus_inv = __safe_inverse(block_count_minus, column.num_rows)
    block_var *= block_count_minus_inv
    block_threshold = block_var  # block_3std = 3 * standard deviation

    for data_block in norm_column.data:
        data_block -= block_avg
        data_block *= data_block
        data_block *= 1 / 9

    column_devsq = norm_column
    # column_devsq = (deviation^2)/9 = (deviation/3)^2
    # NOTE: (deviation/3)^2 > variance   =>   |deviation| > 3 std dev
    eval = column.context.homevaluator
    keypack = column.context.public_key

    for devsq_block, vbit_block in zip(column_devsq.data, res_column.vbit):
        column.context.heaan.math.approx.compare(
            eval, keypack, block_threshold.data, devsq_block.data, devsq_block.data
        )
        if devsq_block.need_bootstrap(4):
            devsq_block.bootstrap()
        # devsq_block now are zeros and ones
        # vbit_block *= devsq_block
        vbit_block *= devsq_block

    return res_column
