import argparse
from utils.data_preperation_utils import *
from utils.type_rels_with_all_info import *
from utils.ner_routines import *
from utils.typing_routines import *
from utils.eval_routines import *


def main():
	parser = argparse.ArgumentParser()

	parser.add_argument('--ner_input_path', type=str,
						default='/Users/teddy/PycharmProjects/Flat-Lattice-Transformer/data/corpus/webhose/webhose_test_bio_%s.txt',
						help='Path to ner input file (preprocessing output).')
	parser.add_argument('--flatner_result_sliced_path', type=str,
						default='/Users/teddy/PycharmProjects/Flat-Lattice-Transformer/V1/predicted_results/pred_results_%d.json',
						help='Path to ner input file (preprocessing output).')
	parser.add_argument('--flat_ner_result_indoc_path', type=str, default='./webhose_data_entries_with_flatner_and_parse.jsonl', help='Path to ner result file.')
	parser.add_argument('--ddparser_path', type=str,
						default='/Users/teddy/Files/Potential Corpus/WebHoses_Chinese_News_Articles/webhose_data_entries_with_corenlp_ner_and_parse.json',
						help='Path to parsing result file.')
	parser.add_argument('--flat_nernet_cfet_sliced_input_path', type=str, default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/webhose_flatner_with_figer_%d.json')
	parser.add_argument('--flat_nernet_cfet_input_path', type=str, default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/webhose_flatner_with_figer.json',
						help='Path to named entity typing input file (from NER results).')
	parser.add_argument('--core_nernet_cfet_sliced_input_path', type=str,
						default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/webhose_corenlpner_with_figer_%d.json')
	parser.add_argument('--core_nernet_cfet_input_path', type=str,
						default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/webhose_corenlpner_with_figer.json',
						help='Path to named entity typing input file (from NER results).')
	parser.add_argument('--flat_nernet_hier_sliced_input_path', type=str,
						default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/webhose_hier_flatner_with_figer_%d.tsv',
						help='Path to sliced HierType NET input from ner results.')
	parser.add_argument('--flat_nernet_hier_input_path', type=str,
						default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/webhose_hier_flatner_with_figer.tsv')
	parser.add_argument('--core_nernet_hier_sliced_input_path', type=str,
						default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/webhose_hier_corenlpner_with_figer_%d.tsv',
						help='Path to sliced HierType NET input from ner results.')
	parser.add_argument('--core_nernet_hier_input_path', type=str,
						default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/webhose_hier_corenlpner_with_figer.tsv')
	parser.add_argument('--nernet_sliced_result_path', type=str, default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/pkls/wiki_data/ner_pred_results/webhose_nernet_pred_results_%s.txt',
						help='Path to NER results typing results files (sliced).')
	parser.add_argument('--arg_typing_input_path', type=str, default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/webhose_arg_with_figer.json',
						help='Path to all parsed subj/obj instances in CFET input format.')
	parser.add_argument('--arg_hier_input_path', type=str, default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/webhose_hier_arg_with_figer.tsv', help='Path to all parsed subj/obj instances in HierType input format')
	parser.add_argument('--arg_typing_input_sliced_path', type=str,
						default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/webhose_arg_with_figer_%d.json',
						help='Path to sliced all parsed subj/obj instances in CFET input format.')
	parser.add_argument('--arg_hier_input_sliced_path', type=str,
						default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/webhose_hier_arg_with_figer_%d.tsv',
						help='Path to sliced all parsed subj/obj instances in HierType input format.')
	parser.add_argument('--arg_typing_result_sliced_path', type=str, default='./cfet_argnet_results/webhose_arg_result_%s.json',
						help='Path to parsed subj/obj NET typing results (with high confidence).')
	# parser.add_argument('--arg_typing_result_sliced_path', type=str, default='./cfet_argnet_results/webhose_argument_pred_results_%s.txt',
	# 					help='Path to parsed subj/obj NET typing results (with high confidence).')
	parser.add_argument('--threshold', type=float, default=0.05, help='confidence threshold for arg_net results.')
	parser.add_argument('--raw_ner_mapping_path', type=str, default='./ner_sent_mapping.jsonl',
						help='Path to NER input file sentence indices mapped to raw document_id and sentence_id')
	parser.add_argument('--argnet_mapping_path', type=str, default='./arg_net_mention_mapping.jsonl',
						help='Path to mapping from doc/sent id to arg_net input mention_id')
	parser.add_argument('--flat_nernet_mapping_path', type=str, default='./flatner_net_mention_mapping.jsonl',
						help='Path to NERNET input file sentence indices mapped to raw (with NER updated sentences) document_id, sentence_id and span_id')
	parser.add_argument('--core_nernet_mapping_path', type=str, default='./corenlpner_net_mention_mapping.jsonl',
						help='Path to NERNET input file sentence indices mapped to raw (with NER updated sentences) document_id, sentence_id and span_id')
	parser.add_argument('--mode', type=str, default=None, help='In which mode to use the utility script [PPNET/PRNER/PRNET/ARGNETDOC/NERNETDOC/TPR/FMTNET/MGNER].')
	parser.add_argument('--amend', type=int, default=1, help='Whether or not to include the amended relations.')
	parser.add_argument('--debug', type=int, default=0, help='Whether or not to show debug details.')
	parser.add_argument('--argnet_documented_path', type=str, default='./argnet_results_per_document.json', help='Path to ARGNET results (thresholded) sorted out per document wise.')
	parser.add_argument('--argnet_thresholded_instances_path', type=str, default='./argnet_thresholded_instances.json', help='Path to ARGNET results (thresholded) in list.')
	parser.add_argument('--argnet_intermediate_path', type=str, default='./argnet_intermediate_res.json', help='Path to argnet results found from previous rounds.')
	parser.add_argument('--argnet_already_merged', type=int, default=0)
	parser.add_argument('--nernet_documented_path', type=str, default='./nernet_results_per_document.json', help='Path to NERNET results sorted out per document wise.')
	parser.add_argument('--typed_triples_documented_path', type=str, default='./typed_triples_documented.json', help='Path to final typed triples for the whole corpus.')
	parser.add_argument('--typed_triples_tacl_path', type=str, default='./typed_triples_tacl.json', help='Path to final typed triples in a format ready as TACL codebase input.')
	parser.add_argument('--typed_triples_stats_path', type=str, default='./typed_triples_stats.json', help='Path to statistics json file for typed triples')
	parser.add_argument('--checkraw', type=bool, default=False, help='in PRNET mode, whether or not to check mapping with raw entries (would make things much slower, but more reassuring.)')
	parser.add_argument('--cache', type=bool, default=False, help='in PRNET mode, whether or not to use cache to reload the ner_results_indoc.')
	parser.add_argument('--net_to_convert_path', type=str, default='', help='in FMTNET mode, the input NET file to format.')
	parser.add_argument('--net_converted_path', type=str, default='', help='in FMTNET mode, the output NET file formatted.')
	parser.add_argument('--net_tsv_mapping_path', type=str, default='', help='in FMTNET mode, the mapping between prediction mention_id and line number.')
	parser.add_argument('--is_predict', type=int, default=0, help='in FMTNET mode, whether the input file is a prediction file.')
	parser.add_argument('--num_slices', type=int, default=8)
	parser.add_argument('--ner_source', type=str, default='flat', help='flat/corenlp')
	parser.add_argument('--entity_pool_path', type=str, default='./webhose_entity_pool.json',
						help='Entity pool extracted from preparing relation arguments for typing, potentially could be used in linking.')
	parser.add_argument('--corenlp_ner_result_path', type=str,
						default='/Users/teddy/Files/Potential Corpus/WebHoses_Chinese_News_Articles/webhose_data_entries_with_corenlp_ner_and_parse.json',
						help='in document file for ')
	parser.add_argument('--both_ner_result_path', type=str,
						default='./webhose_data_entries_with_allner_and_parse.json')
	parser.add_argument('--add_crossed', type=int, default=0)
	parser.add_argument('--add_coarse', type=int, default=1)
	parser.add_argument('--levy_input_path', type=str, default='/Users/teddy/Files/relational-implication-dataset_levy_holts/%s/%s_translated.tsv')
	parser.add_argument('--levy_raw_path', type=str, default='/Users/teddy/Files/relational-implication-dataset_levy_holts/%s/%s_translated_raw.tsv')
	parser.add_argument('--levy_arguments_path_cfet', type=str, default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/levy_%s.json')
	parser.add_argument('--levy_arguments_path_hier', type=str, default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/levy_%s.tsv')
	parser.add_argument('--levy_arguments_mapping_path', type=str, default='./levy_arguments_mapping_%s.json')
	parser.add_argument('--levy_output_path', type=str, default='/Users/teddy/Files/relational-implication-dataset_levy_holts/%s/%s_%s_rels.txt')
	parser.add_argument('--levy_rel_mapping_path', type=str, default='/Users/teddy/Files/relational-implication-dataset_levy_holts/%s/%s_rellevy_mapping.txt')
	parser.add_argument('--levy_typedrel_mapping_path', type=str, default='/Users/teddy/Files/relational-implication-dataset_levy_holts/%s/%s_typed_rel_levy_mapping.txt')
	parser.add_argument('--levy_typing_output_path', type=str, default='./levynet_results/levy_result_%s.json')
	parser.add_argument('--levy_subset', type=str, default='implications')
	parser.add_argument('--levy_use_all_types', type=int, default=0)
	parser.add_argument('--argnetdoc_store', type=int, default=1)
	parser.add_argument('--retrieve_unary', type=int, default=0)
	parser.add_argument('--reformat_time', type=int, default=1)
	parser.add_argument('--translation_consistency_threshold', type=float, default=0.2)

	parser.add_argument('--jia_parser_path', type=str, default='/Users/teddy/PycharmProjects/open-entity-relation-extraction/data/webhose_data_entries_no_corenlp.jsonl')
	parser.add_argument('--jia_arg_typing_input_path', type=str, default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/jia_arg_with_figer.json')
	parser.add_argument('--jia_arg_typing_input_sliced_path', type=str, default='/Users/teddy/PycharmProjects/cfet_both_layer/cfet_data/data/jia_arg_with_figer_%d.json')
	parser.add_argument('--jia_arg_hier_input_path', type=str, default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/jia_hier_arg_with_figer.tsv')
	parser.add_argument('--jia_arg_hier_input_sliced_path', type=str, default='/Users/teddy/PycharmProjects/hierarchical-typing/data/cfet/jia_hier_arg_with_figer_%d.tsv')
	parser.add_argument('--jia_argnet_mapping_path', type=str, default='./jia_arg_net_mention_mapping.jsonl')
	parser.add_argument('--jia_entity_pool_path', type=str, default='./jia_entity_pool.json')
	parser.add_argument('--jia_argnet_thresholded_instances_path', type=str, default='./jia_argnet_thresholded_instances.json')
	parser.add_argument('--jia_arg_typing_result_sliced_path', type=str, default='./jia_argnet_results/jia_hier_arg_result_with_figer_%s.json')
	parser.add_argument('--jia_argnet_documented_path', type=str, default='./jia_argnet_results_per_document.json')
	parser.add_argument('--jia_typed_triples_documented_path', type=str, default='./jia_typed_triples_documented.json')
	parser.add_argument('--jia_typed_triples_tacl_path', type=str, default='./jia_typed_triples_tacl.json')
	parser.add_argument('--jia_typed_triples_stats_path', type=str, default='./jia_typed_triples_stats.json')
	# parser.add_argument('--jia_corenlp_ner_result_path', type=str, default='/Users/teddy/PycharmProjects/open-entity-relation-extraction/data/jia_webhose_data_entries_with_corenlpner_and_parse.json')
	parser.add_argument('--jia_both_ner_result_path', type=str, default='/Users/teddy/PycharmProjects/open-entity-relation-extraction/data/webhose_data_entries_both_ner.jsonl')

	parser.add_argument('--bsl_typed_triples_documented_path', type=str, default='./bsl_typed_triples_documented.json')
	parser.add_argument('--bsl_typed_triples_tacl_path', type=str, default='./bsl_typed_triples_tacl.json')
	parser.add_argument('--bsl_typed_triples_stats_path', type=str, default='./bsl_typed_triples_stats.json')

	# TODO: specify LEVYFET and LEVYFMT paths for (Jia et al 2018) baseline

	args = parser.parse_args()
	args.add_crossed = True if args.add_crossed > 0 else False
	args.add_coarse = True if args.add_coarse > 0 else False
	args.reformat_time = True if args.reformat_time > 0 else False

	if args.mode == 'PPNET':
		print("Working in prepare_parsed_arguments_for_typing mode!")
		prepare_parsed_arguments_for_typing(args.ddparser_path, args.arg_typing_input_path, args.arg_typing_input_sliced_path,
											args.arg_hier_input_path, args.arg_hier_input_sliced_path,
											args.argnet_mapping_path, args.entity_pool_path, args.argnet_documented_path,
											args.argnet_intermediate_path, args.num_slices)
	elif args.mode == 'PPNETJIA':
		print("Working in prepare_parsed_arguments_for_typing mode for Jia et al baseline!")
		prepare_parsed_arguments_for_typing(args.jia_parser_path, args.jia_arg_typing_input_path,
											args.jia_arg_typing_input_sliced_path,
											args.jia_arg_hier_input_path, args.jia_arg_hier_input_sliced_path,
											args.jia_argnet_mapping_path, args.jia_entity_pool_path,
											None, None,
											args.num_slices, jia_baseline=1)
	elif args.mode == 'PRNER':
		print("Working in prepare_corpus_for_ner mode!")
		prepare_corpus_for_ner(args.ddparser_path, args.ner_input_path, args.raw_ner_mapping_path, args.num_slices)
	elif args.mode == 'PRNET':
		print("Working in prepare_ner_result_for_net mode!")
		print("This should be unnecessary!", file=sys.stderr)
		# this first step is necessary only for using FlatTransformer as ner model, because their output format is CONLL-U
		if args.ner_source == 'flat':
			merge_flat_ner_results_in_doc(args.flatner_result_sliced_path, args.ner_input_path, args.raw_ner_mapping_path,
										  args.checkraw, args.ddparser_path, args.debug, args.flat_ner_result_indoc_path,
										  args.num_slices)

			prepare_indoc_ner_results_for_net(args.flat_ner_result_indoc_path, args.flat_nernet_cfet_sliced_input_path,
											  args.flat_nernet_cfet_input_path, args.flat_nernet_hier_sliced_input_path,
											  args.flat_nernet_hier_input_path, args.flat_nernet_mapping_path,
											  args.entity_pool_path, args.ner_source, args.num_slices)
		elif args.ner_source == 'corenlp':
			prepare_indoc_ner_results_for_net(args.corenlp_ner_result_path, args.core_nernet_cfet_sliced_input_path,
											  args.core_nernet_cfet_input_path, args.core_nernet_hier_sliced_input_path,
											  args.core_nernet_hier_input_path, args.core_nernet_mapping_path,
											  args.entity_pool_path, args.ner_source, args.num_slices)
		else:
			raise AssertionError
	elif args.mode == 'ARGNETDOC':
		print("Working in merge_and_threshold_argnet_results mode!")
		if args.argnetdoc_store == 0:
			args.argnet_thresholded_instances_path = None
		args.argnet_already_merged = args.argnet_already_merged > 0
		if not args.argnet_already_merged:
			merge_argnet_results(args.argnet_thresholded_instances_path, args.arg_typing_result_sliced_path,
								 args.threshold, args.num_slices)
		else:
			print("ARGNET already merged into one file and thresholded!")
		print("MERGED ARGNET RESULTS INTO ONE FILE!")
		create_indoc_file_argnet_results(args.argnet_thresholded_instances_path, args.argnet_mapping_path, args.ddparser_path,
										 args.argnet_intermediate_path, args.argnet_documented_path)
	elif args.mode == 'ARGNETDOCJIA':
		print("Working in merge_and_threshold_argnet_results mode for Jia et al baseline!")
		if args.argnetdoc_store == 0:
			args.argnet_thresholded_instances_path = None
		merge_argnet_results(args.jia_argnet_thresholded_instances_path, args.jia_arg_typing_result_sliced_path, args.threshold,
							 args.num_slices)
		print("MERGED ARGNET RESULTS INTO ONE FILE!")
		create_indoc_file_argnet_results(args.jia_argnet_thresholded_instances_path, args.jia_argnet_mapping_path,
										 args.jia_parser_path, None,
										 args.jia_argnet_documented_path)
	elif args.mode == 'NERNETDOC':
		print("Working in merge_nernet_results mode!")
		print("This should be unnecessary!", file=sys.stderr)
		merge_nernet_results(args.nernet_sliced_result_path, args.nernet_mapping_path, args.ddparser_path, args.debug,
							 args.nernet_documented_path, args.num_slices)
	elif args.mode == 'TPR':
		print("Working in type_parsed_relations mode!")
		assert args.typed_triples_documented_path[-5:] == '.json'
		if args.add_coarse is False:
			args.typed_triples_documented_path = args.typed_triples_documented_path[:-5] + '_nocoarse.json'
		if args.add_crossed is True:
			args.typed_triples_documented_path = args.typed_triples_documented_path[:-5] + '_withcrossed.json'
		typed_triples_documented_excluded_path = args.typed_triples_documented_path[:-5] + '_excluded.json'
		assert args.typed_triples_tacl_path[-5:] == '.json'
		if args.add_coarse is False:
			args.typed_triples_tacl_path = args.typed_triples_tacl_path[:-5] + '_nocoarse.json'
		if args.add_crossed is True:
			args.typed_triples_tacl_path = args.typed_triples_tacl_path[:-5] + '_withcrossed.json'
		typed_triples_tacl_excluded_path = args.typed_triples_tacl_path[:-5] + '_excluded.json'

		type_acquired_relations(args.both_ner_result_path, args.argnet_documented_path, args.ddparser_path,
								args.typed_triples_documented_path, typed_triples_documented_excluded_path,
								args.typed_triples_stats_path, True, args.debug, is_jia_baseline=False,
								add_crossed=args.add_crossed, add_coarse=args.add_coarse)
		format_parsed_triples_to_tacl(args.typed_triples_documented_path, args.typed_triples_tacl_path, args.retrieve_unary, args.reformat_time)
		format_parsed_triples_to_tacl(typed_triples_documented_excluded_path, typed_triples_tacl_excluded_path, args.retrieve_unary, args.reformat_time)
	elif args.mode == 'TPRJIA':
		print("Working in type_parsed_relations mode for Jia et al 2018!")
		assert args.jia_typed_triples_documented_path[-5:] == '.json'
		jia_typed_triples_documented_excluded_path = args.jia_typed_triples_documented_path[:-5] + '_excluded.json'
		assert args.jia_typed_triples_tacl_path[-5:] == '.json'
		jia_typed_triples_tacl_excluded_path = args.jia_typed_triples_tacl_path[:-5] + '_excluded.json'

		type_acquired_relations(args.jia_both_ner_result_path, args.jia_argnet_documented_path, args.jia_parser_path,
								args.jia_typed_triples_documented_path, jia_typed_triples_documented_excluded_path,
								args.jia_typed_triples_stats_path, False, args.debug, is_jia_baseline=True,
								add_crossed=args.add_crossed, add_coarse=args.add_coarse)
		format_parsed_triples_to_tacl(args.jia_typed_triples_documented_path, args.jia_typed_triples_tacl_path,
									  args.retrieve_unary, args.reformat_time)
		format_parsed_triples_to_tacl(jia_typed_triples_documented_excluded_path, jia_typed_triples_tacl_excluded_path,
									  args.retrieve_unary, args.reformat_time)
	elif args.mode == 'TPRBSL':
		print("Working in type_parsed_relations mode for DDParser baseline!")
		assert args.bsl_typed_triples_documented_path[-5:] == '.json'
		bsl_typed_triples_documented_excluded_path = args.bsl_typed_triples_documented_path[:-5] + '_excluded.json'
		assert args.bsl_typed_triples_tacl_path[-5:] == '.json'
		bsl_typed_triples_tacl_excluded_path = args.bsl_typed_triples_tacl_path[:-5] + '_excluded.json'

		type_acquired_relations(args.both_ner_result_path, args.argnet_documented_path, args.ddparser_path,
								args.bsl_typed_triples_documented_path, bsl_typed_triples_documented_excluded_path,
								args.bsl_typed_triples_stats_path, False, args.debug, is_jia_baseline=False,
								add_crossed=args.add_crossed, add_coarse=args.add_coarse)
		format_parsed_triples_to_tacl(args.bsl_typed_triples_documented_path, args.bsl_typed_triples_tacl_path,
									  args.retrieve_unary, args.reformat_time)
		format_parsed_triples_to_tacl(bsl_typed_triples_documented_excluded_path, bsl_typed_triples_tacl_excluded_path,
									  args.retrieve_unary, args.reformat_time)
	elif args.mode == 'FMTTPS':
		print("Working in format_parsed_triples_to_tacl mode!")
		assert args.typed_triples_documented_path[-5:] == '.json'
		typed_triples_documented_excluded_path = args.typed_triples_documented_path[:-5] + '_excluded.json'
		assert args.typed_triples_tacl_path[-5:] == '.json'
		typed_triples_tacl_excluded_path = args.typed_triples_tacl_path[:-5] + '_excluded.json'
		format_parsed_triples_to_tacl(args.typed_triples_documented_path, args.typed_triples_tacl_path, args.retrieve_unary, args.reformat_time)
		format_parsed_triples_to_tacl(typed_triples_documented_excluded_path, typed_triples_tacl_excluded_path, args.retrieve_unary, args.reformat_time)
	elif args.mode == 'FMTNET':
		print("Working in format_net_input_for_hier mode!")
		print("This should be unnecessary!", file=sys.stderr)
		format_net_input_for_hier(args.net_to_convert_path, args.net_converted_path, args.net_tsv_mapping_path, args.is_predict)
	elif args.mode == 'MGNER':
		print("Working in merge_flatandcorenlp_ner_results mode!")
		merge_flat_ner_results_in_doc(args.flatner_result_sliced_path, args.ner_input_path, args.raw_ner_mapping_path,
									  args.checkraw, args.ddparser_path, args.debug, args.flat_ner_result_indoc_path,
									  args.num_slices)
		merge_flatandcorenlp_ner_results(args.flat_ner_result_indoc_path, args.corenlp_ner_result_path, args.both_ner_result_path)
	elif args.mode == 'ASNER':
		print("Working in assign_corenlp_ner_as_final mode!")
		assign_corenlp_ner_as_final(args.corenlp_ner_result_path, args.both_ner_result_path)
	elif args.mode == 'ASNERJIA':
		print("Working in assign_corenlp_ner_as_final mode for Jia et al 2018!")
		assign_corenlp_ner_as_final(args.jia_corenlp_ner_result_path, args.jia_both_ner_result_path)
	elif args.mode == 'LEVYFET':
		args.levy_input_path = args.levy_input_path % (args.levy_subset, args.levy_subset)
		args.levy_raw_path = args.levy_raw_path % (args.levy_subset, args.levy_subset)
		args.levy_arguments_path_cfet = args.levy_arguments_path_cfet % args.levy_subset
		args.levy_arguments_path_hier = args.levy_arguments_path_hier % args.levy_subset
		args.levy_arguments_mapping_path = args.levy_arguments_mapping_path % args.levy_subset
		prepare_levy_for_typing(args.levy_input_path, args.levy_raw_path, args.levy_arguments_path_cfet, args.levy_arguments_path_hier, args.levy_arguments_mapping_path)
	elif args.mode == 'LEVYFMT':
		args.levy_input_path = args.levy_input_path % (args.levy_subset, args.levy_subset)
		args.levy_raw_path = args.levy_raw_path % (args.levy_subset, args.levy_subset)
		args.levy_arguments_mapping_path = args.levy_arguments_mapping_path % args.levy_subset
		args.levy_typing_output_path = args.levy_typing_output_path % args.levy_subset
		args.levy_output_path = args.levy_output_path % (args.levy_subset, args.levy_subset, '%s')
		args.levy_rel_mapping_path = args.levy_rel_mapping_path % (args.levy_subset, args.levy_subset)
		args.levy_typedrel_mapping_path = args.levy_typedrel_mapping_path % (args.levy_subset, args.levy_subset)
		args.levy_use_all_types = True if args.levy_use_all_types > 0 else False
		format_levy_for_evaluation(args.levy_input_path, args.levy_typing_output_path, args.levy_arguments_mapping_path,
								   args.levy_output_path, args.levy_rel_mapping_path, args.levy_typedrel_mapping_path,
								   args.translation_consistency_threshold, args.levy_use_all_types)
		align_raw_with_typed_rels(args.levy_input_path, args.levy_raw_path, args.levy_typedrel_mapping_path)
	elif args.mode == 'LEVYPHDR':
		# Levy typing placeholder.
		args.levy_arguments_path_hier = args.levy_arguments_path_hier % args.levy_subset
		args.levy_typing_output_path = args.levy_typing_output_path % args.levy_subset
		get_placeholder_types(args.levy_arguments_path_hier, args.levy_typing_output_path)
	else:
		raise NotImplementedError


if __name__ == '__main__':
	main()


