#!/usr/bin/bash
workspace=/workspace
source $workspace/bashrc
save_dir=$workspace/models/naive_mnmt_opus_100_master
codes_dir=$workspace/codes/git-repo/fairseq-master
data_dir=$workspace/experiments/experiments-opus-100/opus_naive_mnmt

seed=1111
max_tokens=4096
dropout=0.1
attention_heads=8
embed_dim=512
ffn_embed_dim=2048
encoder_layers=6
decoder_layers=6

lr=0.001
update_freq=1

save_dir=${save_dir}_${encoder_layers}_${decoder_layers}_${lr}_${update_freq}

mkdir -p $save_dir

export CUDA_VISIBLE_DEVICES='0,1,2,3,4,5,6,7'
#export CUDA_VISIBLE_DEVICES='0'

lang_pairs=""
pre_prefix=""
langs="en"
while read line
do 
    prefix=${line: -14: -9}
    if [ "$prefix"x == "$pre_prefix"x ]; then
        #echo "same prefix"
        continue 2
    fi
    pre_prefix=$prefix
    src_lang=${prefix: 0: 2}
    tgt_lang=${prefix: 3}

    include=$(echo $langs | grep "${src_lang}")
    if [[ "$include" != "" ]]; then
        echo "src include"
    else
        langs=${langs}-${src_lang}
    fi

    include=$(echo $langs | grep "${tgt_lang}")
    if [[ "$include" != "" ]]; then
        echo "tgt include"
    else
        langs=${langs}-${tgt_lang}
    fi

    lang_pairs=${lang_pairs},${prefix},${tgt_lang}-${src_lang}

done < $data_dir/train_file.txt

lang_pairs=${lang_pairs: 1}
echo $lang_pairs
echo ${langs}

python $codes_dir/train.py $data_dir/data-bin \
    --task multilingual_translation \
    --arch multilingual_transformer \
    --lang-pairs $lang_pairs \
    --save-dir $save_dir \
    --optimizer adam --adam-betas '(0.9, 0.98)' --clip-norm 0.0 \
    --lr-scheduler inverse_sqrt --lr ${lr} --max-update 500000 \
    --warmup-updates 8000 --warmup-init-lr '1e-07' \
    --criterion label_smoothed_cross_entropy --label-smoothing 0.1 \
    --seed ${seed} \
    --max-tokens ${max_tokens} --update-freq ${update_freq} \
    --dropout ${dropout} --relu-dropout 0.1 --attention-dropout 0.1 \
    --decoder-attention-heads ${attention_heads} --encoder-attention-heads ${attention_heads} \
    --decoder-embed-dim ${embed_dim} --encoder-embed-dim ${embed_dim} \
    --decoder-ffn-embed-dim ${ffn_embed_dim} --encoder-ffn-embed-dim ${ffn_embed_dim} \
    --encoder-layers ${encoder_layers} --decoder-layers ${decoder_layers} \
    --share-all-embeddings --share-encoders --share-decoders \
    --log-format simple  --log-interval 500 \
    --keep-interval-updates 10 --save-interval-updates 3000 \
    --encoder-langtok 'tgt' \
    --ddp-backend=no_c10d \
    --fp16 \
    --skip-invalid-size-inputs-valid-test \
    >${save_dir}/train.log 2>&1
