LANGUAGE=$1
cd ~/moie/code
python create_multi2oie_data.py --lang ${LANGUAGE} 

conda activate multi2oie

cd ~/Multi2OIE/utils
python preprocess.py --mode 'train' --data ~/moie/data/${LANGUAGE}/multi2oie/structured_data_${LANGUAGE}.json  --save_path ~/moie/data/${LANGUAGE}/multi2oie/train.pkl  --bert_config 'bert-base-multilingual-cased' --max_len 128

cd ~/Multi2OIE
python main.py --save_path ./${LANGUAGE}_results --bert_config bert-base-multilingual-cased --trn_data_path ~/moie/data/${LANGUAGE}/multi2oie/train.pkl  --dev_data_path ~/moie/data/${LANGUAGE}/multi2oie/dev_sentences.pkl --dev_gold_path ~/moie/data/${LANGUAGE}/multi2oie/carb_dev.tsv --batch_size 32 --epochs 8 --visible_device 3 --max_len 128

## Replace the model-epoch* with the best model on dev set. Look at $LANGUAGE_results/train.csv for the dev scores at different epochs
python test.py --model_path ${LANGUAGE}_results/model-epoch3-end-score0.9334.bin    --save_path ./${LANGUAGE}_results/ --bert_config bert-base-multilingual-cased --test_data_path ~/moie/code/carb/data/${LANGUAGE}_test.input --binary --visible_device 1
## Zero-Shot
# python test.py --model_path en/results/model-epoch4-end-score1.6087.bin    --save_path ./${LANGUAGE}_results/ --bert_config bert-base-multilingual-cased --test_data_path ~/moie/code/carb/data/${LANGUAGE}_test.input --binary --visible_device 1 

cd ~/moie/code
python carb/carb.py --allennlp ~/Multi2OIE/${LANGUAGE}_results/extraction.txt  --gold carb/data/gold/${LANGUAGE}_test.tsv --out /dev/null 