/*
 * Decompiled with CFR 0.152.
 */
package se.liu.ida.nlp.sdp.toolkit.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import se.liu.ida.nlp.sdp.toolkit.graph.Edge;
import se.liu.ida.nlp.sdp.toolkit.graph.Graph;
import se.liu.ida.nlp.sdp.toolkit.graph.Node;
import se.liu.ida.nlp.sdp.toolkit.io.GraphReader2015;

public class Scorer {
    private static final String UNLABELED = "-UNLABELED-";
    private static final String VIRTUAL = "-VIRTUAL-";
    private static final String NO_SENSE = "-NOSENSE-";
    private final boolean includeLabels;
    private final boolean includeTopNodes;
    private final boolean includePunctuation;
    private final boolean treatEdgesAsUndirected;
    private int nGraphs;
    private final Set<ScorerEdge> edgesInGoldStandard;
    private final Set<ScorerEdge> edgesInSystemOutput;
    private int nExactMatches;
    private final Set<SemanticFrame> semanticFramesInGoldStandard;
    private final Set<SemanticFrame> semanticFramesInSystemOutput;
    private final Set<SemanticFrame> corePredicationsInGoldStandard;
    private final Set<SemanticFrame> corePredicationsInSystemOutput;
    private final ArgumentFilter labelPredicate;

    public Scorer(boolean includeLabels, boolean includeTopNodes, boolean includePunctuation, boolean treatEdgesAsUndirected, ArgumentFilter labelPredicate) {
        this.includeLabels = includeLabels;
        this.includeTopNodes = includeTopNodes;
        this.edgesInGoldStandard = new HashSet<ScorerEdge>();
        this.edgesInSystemOutput = new HashSet<ScorerEdge>();
        this.includePunctuation = includePunctuation;
        this.treatEdgesAsUndirected = treatEdgesAsUndirected;
        this.semanticFramesInGoldStandard = new HashSet<SemanticFrame>();
        this.semanticFramesInSystemOutput = new HashSet<SemanticFrame>();
        this.corePredicationsInGoldStandard = new HashSet<SemanticFrame>();
        this.corePredicationsInSystemOutput = new HashSet<SemanticFrame>();
        this.labelPredicate = labelPredicate;
    }

    public Scorer() {
        this(true, true, true, false, new TrueFilter());
    }

    public void update(Graph goldStandard, Graph systemOutput) {
        assert (goldStandard.getNNodes() == systemOutput.getNNodes());
        Set<ScorerEdge> edgesG = this.getEdges(goldStandard);
        Set<ScorerEdge> edgesS = this.getEdges(systemOutput);
        ++this.nGraphs;
        this.nExactMatches += edgesG.equals(edgesS) ? 1 : 0;
        this.edgesInGoldStandard.addAll(edgesG);
        this.edgesInSystemOutput.addAll(edgesS);
        Set<SemanticFrame> semanticFramesG = this.getSemanticFrames(goldStandard);
        Set<SemanticFrame> semanticFramesS = this.getSemanticFrames(systemOutput);
        this.semanticFramesInGoldStandard.addAll(semanticFramesG);
        this.semanticFramesInSystemOutput.addAll(semanticFramesS);
        Set<SemanticFrame> corePredicationsG = this.getCorePredications(goldStandard);
        Set<SemanticFrame> corePredicationsS = this.getCorePredications(systemOutput);
        this.corePredicationsInGoldStandard.addAll(corePredicationsG);
        this.corePredicationsInSystemOutput.addAll(corePredicationsS);
    }

    private boolean isPunctuation(Node node) {
        return node.pos.equals(".") || node.pos.equals(",") || node.pos.equals(":") || node.pos.equals("(") || node.pos.equals(")");
    }

    private boolean edgeIsAdmissible(Graph graph, int src, int tgt) {
        if (this.includePunctuation) {
            return true;
        }
        return !this.isPunctuation(graph.getNode(src)) && !this.isPunctuation(graph.getNode(tgt));
    }

    private Set<ScorerEdge> getEdges(Graph graph) {
        HashSet<ScorerEdge> edges = new HashSet<ScorerEdge>();
        for (Edge edge : graph.getEdges()) {
            if (!this.edgeIsAdmissible(graph, edge.source, edge.target)) continue;
            String label = this.includeLabels ? edge.label : UNLABELED;
            edges.add(this.makeEdge(this.nGraphs, edge.source, edge.target, label));
        }
        if (this.includeTopNodes) {
            for (Node node : graph.getNodes()) {
                if (!node.isTop || !this.edgeIsAdmissible(graph, 0, node.id)) continue;
                edges.add(this.makeEdge(this.nGraphs, 0, node.id, VIRTUAL));
            }
        }
        return edges;
    }

    public int getNEdgesInGoldStandard() {
        return this.edgesInGoldStandard.size();
    }

    public int getNEdgesInSystemOutput() {
        return this.edgesInSystemOutput.size();
    }

    public double getPrecision() {
        return (double)this.getNEdgesInCommon() / (double)this.getNEdgesInSystemOutput();
    }

    public double getRecall() {
        return (double)this.getNEdgesInCommon() / (double)this.getNEdgesInGoldStandard();
    }

    private Set<ScorerEdge> getEdgesInCommon() {
        HashSet<ScorerEdge> intersection = new HashSet<ScorerEdge>(this.edgesInGoldStandard);
        intersection.retainAll(this.edgesInSystemOutput);
        return intersection;
    }

    public int getNEdgesInCommon() {
        return this.getEdgesInCommon().size();
    }

    public double getF1() {
        double p = this.getPrecision();
        double r = this.getRecall();
        return 2.0 * p * r / (p + r);
    }

    public double getExactMatch() {
        return (double)this.nExactMatches / (double)this.nGraphs;
    }

    private boolean representsScorablePredicate(Node node) {
        return node.isPred && node.pos.startsWith("V");
    }

    private Set<SemanticFrame> getSemanticFrames(Graph graph) {
        HashSet<SemanticFrame> semanticFrames = new HashSet<SemanticFrame>();
        for (Node node : graph.getNodes()) {
            if (!this.representsScorablePredicate(node)) continue;
            HashSet<ScorerEdge> outgoingEdges = new HashSet<ScorerEdge>();
            for (Edge edge : node.getOutgoingEdges()) {
                if (!this.labelPredicate.applies(edge.label)) continue;
                ScorerEdge scorerEdge = new ScorerEdge(this.nGraphs, edge.source, edge.target, edge.label);
                outgoingEdges.add(scorerEdge);
            }
            SemanticFrame frame = new SemanticFrame(this.nGraphs, node.id, node.sense, outgoingEdges);
            semanticFrames.add(frame);
        }
        return semanticFrames;
    }

    public int getNSemanticFramesInGoldStandard() {
        return this.semanticFramesInGoldStandard.size();
    }

    public int getNSemanticFramesInSystemOutput() {
        return this.semanticFramesInSystemOutput.size();
    }

    public double getSemanticFramesPrecision() {
        return (double)this.getNSemanticFramesInCommon() / (double)this.getNSemanticFramesInSystemOutput();
    }

    public double getSemanticFramesRecall() {
        return (double)this.getNSemanticFramesInCommon() / (double)this.getNSemanticFramesInGoldStandard();
    }

    private Set<SemanticFrame> getSemanticFramesInCommon() {
        HashSet<SemanticFrame> intersection = new HashSet<SemanticFrame>(this.semanticFramesInGoldStandard);
        intersection.retainAll(this.semanticFramesInSystemOutput);
        return intersection;
    }

    public int getNSemanticFramesInCommon() {
        return this.getSemanticFramesInCommon().size();
    }

    public double getSemanticFramesF1() {
        double p = this.getSemanticFramesPrecision();
        double r = this.getSemanticFramesRecall();
        return 2.0 * p * r / (p + r);
    }

    private Set<SemanticFrame> getCorePredications(Graph graph) {
        HashSet<SemanticFrame> semanticFrames = new HashSet<SemanticFrame>();
        for (Node node : graph.getNodes()) {
            if (!this.representsScorablePredicate(node)) continue;
            HashSet<ScorerEdge> outgoingEdges = new HashSet<ScorerEdge>();
            for (Edge edge : node.getOutgoingEdges()) {
                if (!this.labelPredicate.applies(edge.label)) continue;
                ScorerEdge scorerEdge = new ScorerEdge(this.nGraphs, edge.source, edge.target, edge.label);
                outgoingEdges.add(scorerEdge);
            }
            SemanticFrame frame = new SemanticFrame(this.nGraphs, node.id, NO_SENSE, outgoingEdges);
            semanticFrames.add(frame);
        }
        return semanticFrames;
    }

    public int getNCorePredicationsInGoldStandard() {
        return this.corePredicationsInGoldStandard.size();
    }

    public int getNCorePredicationsInSystemOutput() {
        return this.corePredicationsInSystemOutput.size();
    }

    public double getCorePredicationsPrecision() {
        return (double)this.getNCorePredicationsInCommon() / (double)this.getNCorePredicationsInSystemOutput();
    }

    public double getCorePredicationsRecall() {
        return (double)this.getNCorePredicationsInCommon() / (double)this.getNCorePredicationsInGoldStandard();
    }

    private Set<SemanticFrame> getCorePredicationsInCommon() {
        HashSet<SemanticFrame> intersection = new HashSet<SemanticFrame>(this.corePredicationsInGoldStandard);
        intersection.retainAll(this.corePredicationsInSystemOutput);
        return intersection;
    }

    public int getNCorePredicationsInCommon() {
        return this.getCorePredicationsInCommon().size();
    }

    public double getCorePredicationsF1() {
        double p = this.getCorePredicationsPrecision();
        double r = this.getCorePredicationsRecall();
        return 2.0 * p * r / (p + r);
    }

    private static List<GraphPair> readGraphs(String goldStandardFile, String systemOutputFile, int max) throws Exception {
        Graph goldStandard;
        LinkedList<GraphPair> graphPairs = new LinkedList<GraphPair>();
        GraphReader2015 goldStandardReader = new GraphReader2015(goldStandardFile);
        GraphReader2015 systemOutputReader = new GraphReader2015(systemOutputFile);
        for (int nGraphs = 0; (goldStandard = goldStandardReader.readGraph()) != null && (max < 0 || nGraphs < max); ++nGraphs) {
            Graph systemOutput = systemOutputReader.readGraph();
            graphPairs.add(new GraphPair(goldStandard, systemOutput));
        }
        assert (systemOutputReader.readGraph() == null);
        goldStandardReader.close();
        systemOutputReader.close();
        return graphPairs;
    }

    private static void score(Scorer scorer, List<GraphPair> graphPairs) {
        for (GraphPair pair : graphPairs) {
            scorer.update(pair.goldStandard, pair.systemOutput);
        }
    }

    private static void score(boolean includeTopNodes, boolean includePunctuation, boolean treatEdgesAsUndirected, List<GraphPair> graphPairs, ArgumentFilter labelPredicate) {
        Scorer scorerL = new Scorer(true, includeTopNodes, includePunctuation, treatEdgesAsUndirected, labelPredicate);
        Scorer scorerU = new Scorer(false, includeTopNodes, includePunctuation, treatEdgesAsUndirected, labelPredicate);
        Scorer.score(scorerL, graphPairs);
        Scorer.score(scorerU, graphPairs);
        System.err.format("Number of edges in gold standard: %d%n", scorerL.getNEdgesInGoldStandard());
        System.err.format("Number of edges in system output: %d%n", scorerL.getNEdgesInSystemOutput());
        System.err.format("Number of edges in common, labeled: %d%n", scorerL.getNEdgesInCommon());
        System.err.format("Number of edges in common, unlabeled: %d%n", scorerU.getNEdgesInCommon());
        System.err.println();
        System.err.println("### Labeled scores");
        System.err.println();
        System.err.format("LP: %f%n", scorerL.getPrecision());
        System.err.format("LR: %f%n", scorerL.getRecall());
        System.err.format("LF: %f%n", scorerL.getF1());
        System.err.format("LM: %f%n", scorerL.getExactMatch());
        System.err.println();
        System.err.println("### Breakdown by label type");
        System.err.println();
        System.err.println("Label type,Number of edges in gold standard,Number of edges in system output,Precision,Recall");
        ArrayList<String> labels = new ArrayList<String>(scorerL.getLabels());
        Collections.sort(labels);
        for (String label : labels) {
            System.err.format("%s,%d,%d,%f,%f%n", label, scorerL.getNEdgesInGoldStandardByLabel(label), scorerL.getNEdgesInSystemOutputByLabel(label), scorerL.getPrecisionPerLabel(label), scorerL.getRecallPerLabel(label));
        }
        System.err.println();
        System.err.println("### Breakdown by edge length");
        System.err.println();
        ArrayList<String> quantizedLengths = new ArrayList<String>();
        for (int i = 1; i < 100; ++i) {
            String quantizedLength = scorerL.getQuantizedLength(i);
            if (quantizedLengths.contains(quantizedLength)) continue;
            quantizedLengths.add(quantizedLength);
        }
        System.err.println("Edge length,Number of edges in gold standard,Number of edges in system output,Precision,Recall");
        for (String quantizedLength : quantizedLengths) {
            System.err.format("%s,%d,%d,%f,%f%n", quantizedLength, scorerL.getNEdgesInGoldStandardByQuantizedLength(quantizedLength), scorerL.getNEdgesInSystemOutputByQuantizedLength(quantizedLength), scorerL.getPrecisionPerQuantizedLength(quantizedLength), scorerL.getRecallPerQuantizedLength(quantizedLength));
        }
        System.err.println();
        System.err.println("### Unlabeled scores");
        System.err.println();
        System.err.format("UP: %f%n", scorerU.getPrecision());
        System.err.format("UR: %f%n", scorerU.getRecall());
        System.err.format("UF: %f%n", scorerU.getF1());
        System.err.format("UM: %f%n", scorerU.getExactMatch());
        System.err.println();
        System.err.println("### Core predications");
        System.err.println();
        System.err.format("Number of core predications in gold standard: %d%n", scorerL.getNCorePredicationsInGoldStandard());
        System.err.format("Number of core predications in system output: %d%n", scorerL.getNCorePredicationsInSystemOutput());
        System.err.println();
        System.err.format("CPP: %f%n", scorerL.getCorePredicationsPrecision());
        System.err.format("CPR: %f%n", scorerL.getCorePredicationsRecall());
        System.err.format("CPF: %f%n", scorerL.getCorePredicationsF1());
        System.err.println();
        System.err.println("### Semantic frames");
        System.err.println();
        System.err.format("Number of semantic frames in gold standard: %d%n", scorerL.getNSemanticFramesInGoldStandard());
        System.err.format("Number of semantic frames in system output: %d%n", scorerL.getNSemanticFramesInSystemOutput());
        System.err.println();
        System.err.format("SFP: %f%n", scorerL.getSemanticFramesPrecision());
        System.err.format("SFR: %f%n", scorerL.getSemanticFramesRecall());
        System.err.format("SFF: %f%n", scorerL.getSemanticFramesF1());
    }

    public static void main(String[] args) throws Exception {
        boolean includePunctuation = true;
        boolean treatEdgesAsUndirected = false;
        ArgumentFilter labelPredicate = new TrueFilter();
        int graphsToRead = -1;
        for (String arg : args) {
            if (arg.equals("excludePunctuation")) {
                System.err.println("Will exclude punctuation.");
                includePunctuation = false;
            }
            if (arg.equals("treatEdgesAsUndirected")) {
                System.err.println("Will treat edges as undirected.");
                treatEdgesAsUndirected = true;
            }
            if (arg.startsWith("corePredicates=")) {
                String fileName = arg.substring(15);
                System.err.format("Reading core predicates from %s%n", fileName);
                labelPredicate = new ListFilter(new File(fileName));
            }
            if (arg.startsWith("max=")) {
                graphsToRead = Integer.parseInt(arg.substring(4));
                System.err.format("Will read at most %d graphs.%n", graphsToRead);
            }
            if (!arg.startsWith("representation=")) continue;
            String representation = arg.substring(15).toLowerCase();
            if (representation.equals("dm")) {
                System.err.println("Representation type: DM");
                labelPredicate = new DMArgumentFilter();
            }
            if (representation.equals("pas")) {
                System.err.println("Representation type: PAS");
                labelPredicate = new PASArgumentFilter();
            }
            if (!representation.equals("psd")) continue;
            System.err.println("Representation type: PSD");
            labelPredicate = new PSDPredicate();
        }
        System.err.println("# Evaluation");
        System.err.println();
        System.err.format("Gold standard file: %s%n", args[0]);
        System.err.format("System output file: %s%n", args[1]);
        System.err.println();
        List<GraphPair> graphPairs = Scorer.readGraphs(args[0], args[1], graphsToRead);
        System.err.println("## Scores including virtual dependencies to top nodes");
        System.err.println();
        Scorer.score(true, includePunctuation, treatEdgesAsUndirected, graphPairs, labelPredicate);
        System.err.println();
        System.err.println("## Scores excluding virtual dependencies to top nodes");
        System.err.println();
        Scorer.score(false, includePunctuation, treatEdgesAsUndirected, graphPairs, labelPredicate);
    }

    private ScorerEdge makeEdge(int graphId, int src, int tgt, String label) {
        if (this.treatEdgesAsUndirected) {
            return new UndirectedScorerEdge(graphId, src, tgt, label);
        }
        return new ScorerEdge(graphId, src, tgt, label);
    }

    private Set<String> getLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (ScorerEdge edge : this.edgesInGoldStandard) {
            labels.add(edge.label);
        }
        for (ScorerEdge edge : this.edgesInSystemOutput) {
            labels.add(edge.label);
        }
        return labels;
    }

    private int getNEdgesByLabel(String label, Set<ScorerEdge> edges) {
        int n = 0;
        for (ScorerEdge edge : edges) {
            n += edge.label.equals(label) ? 1 : 0;
        }
        return n;
    }

    private int getNEdgesInGoldStandardByLabel(String label) {
        return this.getNEdgesByLabel(label, this.edgesInGoldStandard);
    }

    private int getNEdgesInSystemOutputByLabel(String label) {
        return this.getNEdgesByLabel(label, this.edgesInSystemOutput);
    }

    private double getPrecisionPerLabel(String label) {
        int nEdges = 0;
        int nCorrect = 0;
        for (ScorerEdge edgeS : this.edgesInSystemOutput) {
            if (!edgeS.label.equals(label)) continue;
            ++nEdges;
            if (!this.edgesInGoldStandard.contains(edgeS)) continue;
            ++nCorrect;
        }
        return (double)nCorrect / (double)nEdges;
    }

    private double getRecallPerLabel(String label) {
        int nEdges = 0;
        int nCorrect = 0;
        for (ScorerEdge edgeG : this.edgesInGoldStandard) {
            if (!edgeG.label.equals(label)) continue;
            ++nEdges;
            if (!this.edgesInSystemOutput.contains(edgeG)) continue;
            ++nCorrect;
        }
        return (double)nCorrect / (double)nEdges;
    }

    private String getQuantizedLength(int length) {
        if (length <= 4) {
            return Integer.toString(length);
        }
        if (length < 10) {
            return "5-9";
        }
        return "10-";
    }

    private String getQuantizedLength(ScorerEdge edge) {
        return this.getQuantizedLength(edge.getLength());
    }

    private Set<String> getQuantizedLengths() {
        HashSet<String> lengths = new HashSet<String>();
        for (ScorerEdge edge : this.edgesInGoldStandard) {
            lengths.add(this.getQuantizedLength(edge));
        }
        for (ScorerEdge edge : this.edgesInSystemOutput) {
            lengths.add(this.getQuantizedLength(edge));
        }
        return lengths;
    }

    private int getNEdgesByQuantizedLength(String quantizedLength, Set<ScorerEdge> edges) {
        int n = 0;
        for (ScorerEdge edge : edges) {
            if (!this.getQuantizedLength(edge).equals(quantizedLength)) continue;
            ++n;
        }
        return n;
    }

    private int getNEdgesInGoldStandardByQuantizedLength(String quantizedLength) {
        return this.getNEdgesByQuantizedLength(quantizedLength, this.edgesInGoldStandard);
    }

    private int getNEdgesInSystemOutputByQuantizedLength(String quantizedLength) {
        return this.getNEdgesByQuantizedLength(quantizedLength, this.edgesInSystemOutput);
    }

    private double getPrecisionPerQuantizedLength(String quantizedLength) {
        int nEdges = 0;
        int nCorrect = 0;
        for (ScorerEdge edgeS : this.edgesInSystemOutput) {
            if (!this.getQuantizedLength(edgeS).equals(quantizedLength)) continue;
            ++nEdges;
            if (!this.edgesInGoldStandard.contains(edgeS)) continue;
            ++nCorrect;
        }
        return (double)nCorrect / (double)nEdges;
    }

    private double getRecallPerQuantizedLength(String quantizedLength) {
        int nEdges = 0;
        int nCorrect = 0;
        for (ScorerEdge edgeG : this.edgesInGoldStandard) {
            if (!this.getQuantizedLength(edgeG).equals(quantizedLength)) continue;
            ++nEdges;
            if (!this.edgesInSystemOutput.contains(edgeG)) continue;
            ++nCorrect;
        }
        return (double)nCorrect / (double)nEdges;
    }

    private static class SemanticFrame {
        final int graphId;
        final int node;
        final String sense;
        final Set<ScorerEdge> outgoingEdges;

        public SemanticFrame(int graphId, int node, String sense, Set<ScorerEdge> outgoingEdges) {
            this.graphId = graphId;
            this.node = node;
            this.sense = sense;
            this.outgoingEdges = outgoingEdges;
        }

        public int hashCode() {
            int hash = 3;
            hash = 53 * hash + this.graphId;
            hash = 53 * hash + this.node;
            hash = 53 * hash + (this.sense != null ? this.sense.hashCode() : 0);
            hash = 53 * hash + (this.outgoingEdges != null ? this.outgoingEdges.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SemanticFrame other = (SemanticFrame)obj;
            if (this.graphId != other.graphId) {
                return false;
            }
            if (this.node != other.node) {
                return false;
            }
            if (this.sense == null ? other.sense != null : !this.sense.equals(other.sense)) {
                return false;
            }
            return !(this.outgoingEdges == null ? other.outgoingEdges != null : !this.outgoingEdges.equals(other.outgoingEdges));
        }
    }

    private static class UndirectedScorerEdge
    extends ScorerEdge {
        public UndirectedScorerEdge(int graphId, int src, int tgt, String label) {
            super(graphId, src, tgt, label);
        }

        @Override
        public int hashCode() {
            int hash = 3;
            hash = 53 * hash + this.graphId;
            hash = 53 * hash + Math.min(this.src, this.tgt);
            hash = 53 * hash + Math.max(this.src, this.tgt);
            hash = 53 * hash + (this.label != null ? this.label.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScorerEdge other = (ScorerEdge)obj;
            if (this.graphId != other.graphId) {
                return false;
            }
            if (Math.min(this.src, this.tgt) != Math.min(other.src, other.tgt)) {
                return false;
            }
            if (Math.max(this.src, this.tgt) != Math.max(other.src, other.tgt)) {
                return false;
            }
            return !(this.label == null ? other.label != null : !this.label.equals(other.label));
        }
    }

    private static class ScorerEdge {
        final int graphId;
        final int src;
        final int tgt;
        final String label;

        public ScorerEdge(int graphId, int src, int tgt, String label) {
            this.graphId = graphId;
            this.src = src;
            this.tgt = tgt;
            this.label = label;
        }

        public int getLength() {
            return Math.max(this.src, this.tgt) - Math.min(this.src, this.tgt);
        }

        public int hashCode() {
            int hash = 3;
            hash = 53 * hash + this.graphId;
            hash = 53 * hash + this.src;
            hash = 53 * hash + this.tgt;
            hash = 53 * hash + (this.label != null ? this.label.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScorerEdge other = (ScorerEdge)obj;
            if (this.graphId != other.graphId) {
                return false;
            }
            if (this.src != other.src) {
                return false;
            }
            if (this.tgt != other.tgt) {
                return false;
            }
            return !(this.label == null ? other.label != null : !this.label.equals(other.label));
        }
    }

    public static class PSDPredicate
    implements ArgumentFilter {
        @Override
        public boolean applies(String label) {
            return label.endsWith("-arg");
        }
    }

    private static class PASArgumentFilter
    implements ArgumentFilter {
        private final Set<String> coreArguments = new HashSet<String>();

        public PASArgumentFilter() {
            this.coreArguments.add("verb_arg1");
            this.coreArguments.add("verb_arg12");
            this.coreArguments.add("verb_arg123");
            this.coreArguments.add("verb_arg1234");
            this.coreArguments.add("verb_mod_arg1");
            this.coreArguments.add("verb_mod_arg12");
            this.coreArguments.add("verb_mod_arg123");
            this.coreArguments.add("verb_mod_arg1234");
            this.coreArguments.add("adj_arg1");
            this.coreArguments.add("adj_arg12");
            this.coreArguments.add("adj_mod_arg1");
            this.coreArguments.add("adj_mod_arg12");
            this.coreArguments.add("coord_arg12");
            this.coreArguments.add("prep_arg12");
            this.coreArguments.add("prep_arg123");
            this.coreArguments.add("prep_mod_arg12");
            this.coreArguments.add("prep_mod_arg123");
        }

        @Override
        public boolean applies(String label) {
            return this.coreArguments.contains(label);
        }
    }

    private static class DMArgumentFilter
    implements ArgumentFilter {
        private DMArgumentFilter() {
        }

        @Override
        public boolean applies(String label) {
            return true;
        }
    }

    private static class ListFilter
    implements ArgumentFilter {
        private final Set<String> labels = new HashSet<String>();

        public ListFilter(File file) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    this.labels.add(line.trim());
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found.");
                System.exit(1);
            }
            catch (IOException e) {
                System.err.println("I/O exception.");
                System.exit(1);
            }
        }

        @Override
        public boolean applies(String label) {
            return this.labels.contains(label);
        }
    }

    private static class TrueFilter
    implements ArgumentFilter {
        private TrueFilter() {
        }

        @Override
        public boolean applies(String label) {
            return true;
        }
    }

    private static interface ArgumentFilter {
        public boolean applies(String var1);
    }

    private static class GraphPair {
        public final Graph goldStandard;
        public final Graph systemOutput;

        public GraphPair(Graph goldStandard, Graph systemOutput) {
            this.goldStandard = goldStandard;
            this.systemOutput = systemOutput;
        }
    }
}

