function [sent_ind, sent_len, totalWords] = csvReader(filename, n_words)
%
%%usage: [sent_ind, sent_len, totalWords] = csvReader(filename, n_words)
%%ptb: <s>: id 45, </s>: id 45
%%wiki: <s>: id 44, </s>: id 43
%%append n_words <s> before each sentences and  </s> at the end of each
fid=fopen(filename,'r');
sent_ind={};
sent_len=[];
count = 1;
while 1
    textline=fgetl(fid);
    if ~ischar(textline), break, end
    data=regexp(textline, ',', 'split');
    len = length(data);
    sent_len(count) = len + n_words + 1;
    sent_ind{count} =zeros(1,sent_len(count));
    sent_ind{count}(1,1:n_words) = 45;
    sent_ind{count}(1,n_words+1:len+n_words) = str2double(data) + 1;
    sent_ind{count}(1,sent_len(count)) = 44;
    count = count + 1;
end
totalWords = sum(sent_len);
fclose(fid);

