/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.ccg.CCG2GR;
import edu.pku.coli.ccg.CategoryInterpretation;
import edu.pku.coli.ccg.CategoryObject;
import fig.basic.Indexer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CandCMarkedupReader {
    Indexer<String> plainCats = new Indexer();
    List<CategoryInterpretation> interprets = new ArrayList<CategoryInterpretation>();
    List<CCG2GR> grs = new ArrayList<CCG2GR>();

    public CandCMarkedupReader() {
        this.interprets = new ArrayList<CategoryInterpretation>();
        this.grs = new ArrayList<CCG2GR>();
    }

    public void dumpFile(PrintWriter interpretWriter, PrintWriter grWriter) {
        for (CategoryInterpretation i : this.interprets) {
            interpretWriter.println(i);
        }
        for (CCG2GR gr : this.grs) {
            grWriter.println(gr);
        }
    }

    public void fromCandC(BufferedReader br) throws IOException {
        String s = br.readLine();
        int state = 0;
        int line = 1;
        String plainCat = null;
        CategoryInterpretation thisInterpretation = null;
        CCG2GR thisGR = null;
        HashMap markedSlot2JuliaSlot = new HashMap();
        while (s != null) {
            if (s.equals("EOP")) break;
            if (s.trim().length() == 0) {
                if (state != 0) {
                    if (!this.plainCats.add(plainCat)) {
                        throw new IllegalArgumentException(String.valueOf(String.format("Line %d: duplicate interpretation for cat ", line)) + this.plainCats);
                    }
                    this.interprets.add(thisInterpretation);
                    this.grs.add(thisGR);
                    thisInterpretation = null;
                    thisGR = null;
                    plainCat = null;
                    markedSlot2JuliaSlot.clear();
                    state = 0;
                }
            } else if ((s = s.replaceAll("#.*$", "").trim()).length() != 0) {
                String[] ss = s.split("\\s", 2);
                switch (state) {
                    case 0: {
                        if (ss[0].startsWith("=")) {
                            String[] words;
                            String[] stringArray = words = ss[1].split("\\s");
                            int n = words.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String word = stringArray[n2];
                                HashSet<String> cons = (HashSet<String>)CCG2GR.GRTemplate.constraintWords.get(ss[0]);
                                if (cons == null) {
                                    cons = new HashSet<String>();
                                }
                                cons.add(word);
                                CCG2GR.GRTemplate.constraintWords.put(ss[0], cons);
                                ++n2;
                            }
                            break;
                        }
                        plainCat = s.replace('(', '{').replace(')', '}');
                        thisInterpretation = new CategoryInterpretation(plainCat);
                        thisGR = new CCG2GR(plainCat);
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (ss.length != 2) {
                            throw new IllegalArgumentException(String.valueOf(String.format("Line %d: duplicate interpretation for cat ", line)) + s);
                        }
                        CategoryObject cat = CategoryObject.fromCACCats((String)ss[1]);
                        thisInterpretation._indexedCat = cat.toPredArgCat();
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (s.charAt(0) == '!') {
                            if (ss.length != 2) {
                                throw new IllegalArgumentException(String.valueOf(String.format("Line %d: duplicate interpretation for cat ", line)) + s);
                            }
                            CategoryObject adjustedCat = CategoryObject.fromCACCats((String)ss[1]);
                            thisInterpretation._adjustedCat = adjustedCat.toPredArgCat();
                            state = 3;
                            break;
                        }
                    }
                    case 3: {
                        if (ss[1].equals("ignore")) break;
                        int mark = Integer.parseInt(ss[0]);
                        int slot = (Integer)markedSlot2JuliaSlot.get(mark);
                        String temp = s.replace(String.valueOf(mark), String.valueOf(slot));
                        thisGR.addTemplate(slot, temp);
                        state = 3;
                    }
                }
            }
            s = br.readLine();
            ++line;
        }
        if (plainCat != null) {
            if (!this.plainCats.add(plainCat)) {
                throw new IllegalArgumentException("duplicate interpretation for cat " + this.plainCats);
            }
            this.interprets.add(thisInterpretation);
        }
    }

    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "UTF-8"));
        CandCMarkedupReader t = new CandCMarkedupReader();
        t.fromCandC(br);
        br.close();
        PrintWriter inter = new PrintWriter(args[1]);
        PrintWriter gr = new PrintWriter(args[2]);
        t.dumpFile(inter, gr);
        inter.close();
        gr.close();
    }
}

