/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.syntax.CCGNode;
import LinguaView.syntax.CCGTerminalNode;
import LinguaView.syntax.CategoryObject;
import SyntaxUtils.CCGBinaryRule;
import SyntaxUtils.CCGUnaryRule;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CCGInternalNode
extends CCGNode {
    public int headChild;
    int numOfChildren;
    CCGNode[] children;

    public CCGInternalNode(String label) {
        label = label.substring(3, label.length() - 1);
        String[] labelSplit = label.split("\\s+");
        this.cat = CategoryObject.fromPlainCat(labelSplit[0]);
        this.headChild = Integer.parseInt(labelSplit[1]);
        this.numOfChildren = Integer.parseInt(labelSplit[2]);
        this.children = new CCGNode[this.numOfChildren];
        if (labelSplit.length > 3) {
            this.additionalInfo = labelSplit[3];
        }
    }

    private CCGInternalNode() {
    }

    public static CCGInternalNode generateNewNode(CCGBinaryRule rule, CCGNode left, CCGNode right) {
        int j;
        CCGInternalNode result = new CCGInternalNode();
        HashMap<CategoryObject.CoindexedObject, CategoryObject.CoindexedObject> indices = new HashMap<CategoryObject.CoindexedObject, CategoryObject.CoindexedObject>();
        result.cat = rule.perform(left.category(), right.category(), indices);
        if (result.cat == null) {
            return null;
        }
        result.children = new CCGNode[2];
        result.children[0] = left;
        result.children[1] = right;
        result.numOfChildren = 2;
        result.headChild = rule.headChild;
        if (left.end + 1 != right.start) {
            throw new IllegalArgumentException("left is not next to right");
        }
        result.start = left.start;
        result.end = right.end;
        result.parString = left.parString;
        result.source = left.source;
        result.unfilledSlots = new HashMap();
        result.slots = new Set[result.end - result.start + 1][];
        result.newlyFilledSlots = new HashMap();
        int i = 0;
        while (i < left.slots.length) {
            result.slots[i] = new Set[left.slots[i].length];
            j = 0;
            while (j < left.slots[i].length) {
                if (left.slots[i][j] != null) {
                    result.slots[i][j] = new HashSet<Integer>(left.slots[i][j]);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < right.slots.length) {
            result.slots[i + left.slots.length] = new Set[right.slots[i].length];
            j = 0;
            while (j < right.slots[i].length) {
                if (right.slots[i][j] != null) {
                    result.slots[i + left.slots.length][j] = new HashSet<Integer>(right.slots[i][j]);
                }
                ++j;
            }
            ++i;
        }
        for (Map.Entry e : indices.entrySet()) {
            Map<CategoryObject.CoindexedObject, Set<Pair<Integer, Integer>>> m;
            CategoryObject.CoindexedObject cHead = (CategoryObject.CoindexedObject)e.getKey();
            CategoryObject.CoindexedObject pHead = (CategoryObject.CoindexedObject)e.getValue();
            if (left.unfilledSlots.containsKey(cHead)) {
                m = left.unfilledSlots;
            } else {
                if (!right.unfilledSlots.containsKey(cHead)) continue;
                m = right.unfilledSlots;
            }
            if (pHead.head().size() > 0) {
                if (cHead.head().size() != 0) continue;
                Set<Pair<Integer, Integer>> toFill = m.get(cHead);
                Set<Integer> heads = pHead.head();
                for (Pair<Integer, Integer> p : toFill) {
                    result.newlyFilledSlots.put(p, heads);
                    result.slots[p.getFirst().intValue() - result.start][p.getSecond().intValue()] = heads;
                }
                continue;
            }
            Set unfilled = (Set)result.unfilledSlots.get(pHead);
            unfilled = unfilled == null ? new HashSet() : unfilled;
            unfilled.addAll(m.get(cHead));
            result.unfilledSlots.put(pHead, unfilled);
        }
        return result;
    }

    public static CCGInternalNode generateNewNode(CCGUnaryRule rule, CCGNode child) {
        CCGInternalNode result = new CCGInternalNode();
        HashMap<CategoryObject.CoindexedObject, CategoryObject.CoindexedObject> indices = new HashMap<CategoryObject.CoindexedObject, CategoryObject.CoindexedObject>();
        result.cat = rule.perform(child.category(), indices);
        if (result.cat == null) {
            return null;
        }
        result.children = new CCGNode[1];
        result.children[0] = child;
        result.numOfChildren = 1;
        result.headChild = 0;
        result.start = child.start;
        result.end = child.end;
        result.parString = child.parString;
        result.source = child.source;
        result.unfilledSlots = new HashMap();
        result.slots = new Set[result.end - result.start + 1][];
        result.newlyFilledSlots = new HashMap();
        int i = 0;
        while (i < child.slots.length) {
            result.slots[i] = new Set[child.slots[i].length];
            int j = 0;
            while (j < child.slots[i].length) {
                if (child.slots[i][j] != null) {
                    result.slots[i][j] = new HashSet<Integer>(child.slots[i][j]);
                }
                ++j;
            }
            ++i;
        }
        for (Map.Entry e : indices.entrySet()) {
            CategoryObject.CoindexedObject cHead = (CategoryObject.CoindexedObject)e.getKey();
            CategoryObject.CoindexedObject pHead = (CategoryObject.CoindexedObject)e.getValue();
            if (!child.unfilledSlots.containsKey(cHead)) continue;
            Set unfilled = (Set)result.unfilledSlots.get(pHead);
            unfilled = unfilled == null ? new HashSet() : unfilled;
            unfilled.addAll(child.unfilledSlots.get(cHead));
            result.unfilledSlots.put(pHead, unfilled);
        }
        return result;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    public Pair<Integer, List<CCGNode>> findPath(int pred, int arg) {
        ArrayList<CCGNode> path = new ArrayList<CCGNode>();
        if (pred > this.end || pred < this.start || arg > this.end || arg < this.start) {
            throw new IllegalArgumentException("Pred or arg not in this node!");
        }
        if (pred == arg) {
            return null;
        }
        CCGInternalNode ancestor = this;
        while (true) {
            if (pred <= ancestor.children[0].end && arg <= ancestor.children[0].end) {
                ancestor = (CCGInternalNode)ancestor.children[0];
                continue;
            }
            if (pred <= ancestor.children[0].end || arg <= ancestor.children[0].end) break;
            ancestor = (CCGInternalNode)ancestor.children[1];
        }
        Stack<CCGInternalNode> ancestor2pred = new Stack<CCGInternalNode>();
        CCGNode temp = ancestor;
        while (temp instanceof CCGInternalNode) {
            CCGInternalNode _temp = temp;
            temp = pred > _temp.children[0].end ? _temp.children[1] : _temp.children[0];
            ancestor2pred.push((CCGInternalNode)temp);
        }
        while (ancestor2pred.size() > 0) {
            path.add((CCGNode)ancestor2pred.pop());
        }
        int i_ancestor = path.size();
        path.add(ancestor);
        temp = ancestor;
        while (temp instanceof CCGInternalNode) {
            CCGNode _temp = temp;
            temp = arg > _temp.children[0].end ? _temp.children[1] : _temp.children[0];
            path.add(temp);
        }
        return new Pair<Integer, List<CCGNode>>(i_ancestor, path);
    }

    @Override
    public String toTreeString() {
        String str = "(" + this.cat + " ";
        CCGNode[] cCGNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode dtr = cCGNodeArray[n2];
            str = String.valueOf(str) + dtr.toTreeString();
            ++n2;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    @Override
    public String toIndentedTreeString(int treeDepth) {
        StringBuffer sb = new StringBuffer();
        sb.append("(" + this.cat + " ");
        sb.append(this.children[0].toIndentedTreeString(treeDepth + 2 + this.cat.toString().length()));
        if (this.children.length == 2) {
            sb.append("\n");
            int i = 0;
            while (i < treeDepth + this.cat.toString().length() + 2) {
                sb.append(" ");
                ++i;
            }
            sb.append(this.children[1].toIndentedTreeString(treeDepth + 2 + this.cat.toString().length()));
        }
        sb.append(")");
        return sb.toString();
    }

    public int prole() {
        return this.numOfChildren;
    }

    @Override
    public String toString() {
        String result = "(<T " + this.cat + " " + this.headChild + " " + this.numOfChildren + "> ";
        CCGNode[] cCGNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            result = String.valueOf(result) + n3.toString() + " ";
            ++n2;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    @Override
    public String toStringWithAdditionalField() {
        StringBuffer sb = new StringBuffer("(<T " + this.cat + " " + this.headChild + " " + this.numOfChildren);
        if (this.additionalInfo != null) {
            sb.append(" " + this.additionalInfo);
        }
        sb.append("> ");
        CCGNode[] cCGNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            sb.append(String.valueOf(n3.toStringWithAdditionalField()) + " ");
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    public CCGNode[] daughters() {
        return this.children;
    }

    @Override
    public CCGTerminalNode headTerm() {
        CCGNode next = this.children[this.headChild];
        while (!(next instanceof CCGTerminalNode)) {
            CCGInternalNode nn = (CCGInternalNode)next;
            next = nn.children[nn.headChild];
        }
        return (CCGTerminalNode)next;
    }

    public CCGNode getHeadDaughter() {
        return this.children[this.headChild];
    }

    public CCGTerminalNode getAnchorThroughPercolation() {
        CCGNode headDaughter = this.getHeadDaughter();
        if (headDaughter.isTerminal()) {
            return (CCGTerminalNode)headDaughter;
        }
        return ((CCGInternalNode)headDaughter).getAnchorThroughPercolation();
    }

    public static void main(String[] args) {
        CCGNode c = CCGInternalNode.getCCGNodeFromString("(<T S[dcl] 0 2> (<T S[dcl] 1 2> (<T NP 1 2> (<L NP[nb]/N PRP$ PRP$ Their NP[nb]_132/N_132>) (<L N NN NN effort N>) ) (<T S[dcl]\\NP 0 2> (<L (S[dcl]\\NP)/(S[pt]\\NP) VBZ VBZ has (S[dcl]\\NP_80)/(S[pt]_81\\NP_80:B)_81>) (<T S[pt]\\NP 0 2> (<T (S[pt]\\NP)/PP 0 2> (<L ((S[pt]\\NP)/PP)/NP VBN VBN received ((S[pt]\\NP_90)/PP_91)/NP_92>) (<T NP 1 2> (<L NP[nb]/N DT DT a NP[nb]_106/N_106>) (<T N 1 2> (<L N/N JJ JJ lukewarm N_101/N_101>) (<L N NN NN response N>) ) ) ) (<T PP 0 2> (<L PP/NP IN IN from PP/NP_111>) (<T NP 1 2> (<L NP[nb]/N DT DT the NP[nb]_125/N_125>) (<T N 1 2> (<L N/N NNP NNP Justice N_120/N_120>) (<L N NNP NNP Department N>) ) ) ) ) ) ) (<L . . . . .>) )", "test");
        Pair<Integer, List<CCGNode>> p = ((CCGInternalNode)c).findPath(2, 5);
        System.out.println(p.getFirst());
        for (CCGNode cxx : p.getSecond()) {
            System.out.println(cxx + "\n");
        }
    }
}

