%{
/*MA****************************************************************/
/*                                                                 */
/*  FILE     tree.y                                                */
/*  MODULE   tree                                                  */
/*  PROGRAM  BitPar                                                */
/*  AUTHOR   Helmut Schmid, IMS, University of Stuttgart           */
/*                                                                 */
/*ME****************************************************************/

#include <assert.h>
#include <stdio.h>

#include <iostream>
using std::cerr;

#include "tree.h"

extern int  yylineno;
extern char *yytext;

void yyerror(char *text);
int yylex( void );
%}

%union {
  Tree   *tree;
  Trees  *trees;
  char   *name;
}

%token <name>      NAME
%type  <tree>      TREE
%type  <trees>     TREES

%%

ALL:        ALL TREE                { process($2); delete $2; }
          | {}
          ;

TREE:       '(' NAME TREES ')'      { $$=new Tree($2,$3); }
          | NAME '/' NAME           { $$=new Tree($3,$1); }
          | NAME                    { $$=new Tree($1); }
          ;

TREES:      TREES TREE              { $1->push_back($2); $$=$1; }
          | TREE                    { $$ = new Trees; $$->push_back($1); }
          ;

%%


extern FILE  *yyin;


/*FA****************************************************************/
/*                                                                 */
/*  yyerror                                                        */
/*                                                                 */
/*FE****************************************************************/

void yyerror(char *text)

{
  cerr << yylineno << ": " << text << " at: ";
  cerr << yytext << "\naborted.\n";
  exit(1);
}
