
/*MA****************************************************************/
/*                                                                 */
/*     File: tree.h                                                */
/*   Author: Helmut Schmid                                         */
/*  Purpose:                                                       */
/*  Created: Tue Jan 21 13:27:46 2003                              */
/* Modified: Thu Jan 15 09:28:26 2009 (schmid)                     */
/*                                                                 */
/*ME****************************************************************/

#include <malloc.h>
#include <stdio.h>

#include <vector>
using std::vector;

class Tree;

typedef vector<Tree*> Trees;


/*****************  class Tree  ************************************/

class Tree {

private:

public:
  char  *label;
  Trees daughters;
  Tree  *mother;

  Tree( char *l ) { label = l; mother = NULL; };

  Tree( char *l, char *l2 ) {
    label = l;
    mother = NULL;
    daughters.push_back(new Tree(l2));
  };

  Tree( char *l, Trees *d ) { 
    label = l;
    daughters = *d;
    mother = NULL;
    for( size_t i=0; i<daughters.size(); i++ )
      daughters[i]->mother = this;
  };

  ~Tree() {
    free(label);
    for( size_t i=0; i<daughters.size(); i++ )
      delete daughters[i];
  }

  bool preterminal() {
    return (daughters.size() == 1 && daughters[0]->daughters.size() == 0);
  }

  void process();
  void print();
};

void process(Tree*);
