/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.parsingExp.TSGparsingBitPar;
import util.FileUtil;
import util.Utility;

public class TSGparsingBitParFile
extends TSGparsingBitPar {
    public TSGparsingBitParFile(File trainingFile, File testFile, File fragmentFile, File outputDir) {
        super(trainingFile, testFile, fragmentFile, outputDir);
    }

    @Override
    public String getClassName() {
        return "TSGparsingBitParFile";
    }

    @Override
    protected void parseWithBitPar() throws Exception {
        Parameters.reportLineFlush("Preparing threads");
        String bitParBuildingFilesPath = String.valueOf(this.outputPath) + "BitParWorkingDir/";
        File bitParBuildingFilesDir = new File(bitParBuildingFilesPath);
        bitParBuildingFilesDir.mkdir();
        int threadLength = Integer.toString(threads).length();
        int sentencesPerThreads = this.testSize / threads;
        int remainingSentences = this.testSize % threads;
        ArrayList<String[]> testSentencesWords = TSGparsingBitParFile.getSentencesWords(this.testTreebank);
        ArrayList<String[]> originalSentencesWords = TSGparsingBitParFile.getSentencesWords(this.originalTestTreebank);
        BitParThreadRunner[] bitParThreadArray = new BitParThreadRunner[threads];
        int reachedIndex = 0;
        int i = 0;
        while (i < threads) {
            int threadIndex = i + 1;
            String number = Utility.padZero(threadLength, threadIndex);
            File outputBitParNbestBackupThread = new File(String.valueOf(bitParBuildingFilesPath) + "outputBitPar_" + nBest + "best_" + number + ".txt");
            File outputBitParNbestPostProcessedThread = new File(String.valueOf(bitParBuildingFilesPath) + "outputBitPar_" + nBest + "best_" + number + "postProcessed.txt");
            File flatFileForBitParThread = new File(String.valueOf(bitParBuildingFilesPath) + "flatFileForBitPar_part" + number + ".txt");
            int sentencesThreads = sentencesPerThreads;
            if (i < remainingSentences) {
                ++sentencesThreads;
            }
            int startingIndex = reachedIndex;
            ArrayList<String[]> testSentencesWordsThread = new ArrayList<String[]>(testSentencesWords.subList(startingIndex, reachedIndex += sentencesThreads));
            TSGparsingBitParFile.printBitParFlatSentence(testSentencesWordsThread, flatFileForBitParThread);
            ArrayList<String[]> originalTestSentencesWordsThread = null;
            originalTestSentencesWordsThread = new ArrayList<String[]>(originalSentencesWords.subList(startingIndex, reachedIndex));
            bitParThreadArray[i] = new BitParThreadRunner(threadIndex, flatFileForBitParThread, outputBitParNbestBackupThread, outputBitParNbestPostProcessedThread, originalTestSentencesWordsThread);
            ++i;
        }
        Parameters.reportLineFlush("Parsing with BitPar using " + threads + " threads");
        Parameters.reportLineFlush("Parsing " + this.testSize + " sentences:");
        this.submitMultithreadJob(bitParThreadArray);
        this.parsedOutputFiles = bitParThreadArray[0].metricOptimizer.makeFileOutputList(String.valueOf(this.outputPath) + "BITPAR_", ".mrg");
        this.parsedOutputFilesIdentifiers = bitParThreadArray[0].metricOptimizer.getIdentifiers();
        BitParThreadRunner[] bitParThreadRunnerArray = bitParThreadArray;
        int n = bitParThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            BitParThreadRunner t = bitParThreadRunnerArray[n2];
            t.metricOptimizer.appendResult(this.parsedOutputFiles);
            ++n2;
        }
        Parameters.reportLineFlush("Finished Parsing.");
    }

    private void submitMultithreadJob(BitParThreadRunner[] bitParThreadArray) {
        int i = 0;
        while (i < threads - 1) {
            BitParThreadRunner t = bitParThreadArray[i];
            t.start();
            ++i;
        }
        bitParThreadArray[threads - 1].run();
        i = 0;
        while (i < threads - 1) {
            try {
                bitParThreadArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            ++i;
        }
    }

    protected class BitParThreadRunner
    extends Thread {
        int threadIndex;
        File flatFileForBitPar;
        File outputBitParNbestThread;
        File outputBitParNbestPostProcessedThread;
        ArrayList<String[]> originalTestSentencesWordsThread;
        MetricOptimizerArray metricOptimizer;

        public BitParThreadRunner(int threadIndex, File flatFileForBitPar, File outputBitParNbestThread, File outputBitParNbestPostProcessedThread, ArrayList<String[]> originalTestSentencesWordsThread) {
            this.threadIndex = threadIndex;
            this.flatFileForBitPar = flatFileForBitPar;
            this.outputBitParNbestThread = outputBitParNbestThread;
            this.outputBitParNbestPostProcessedThread = outputBitParNbestPostProcessedThread;
            this.originalTestSentencesWordsThread = originalTestSentencesWordsThread;
            this.metricOptimizer = new MetricOptimizerArray();
        }

        @Override
        public void run() {
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(String.valueOf(bitparCommandAndArgs) + " " + this.flatFileForBitPar + " " + this.outputBitParNbestThread);
                BufferedReader inputStd = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader inputErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                ReadInputStream inputStandardThread = new ReadInputStream(inputStd);
                ReadErrorStream inputErrorThread = new ReadErrorStream(inputErr);
                inputStandardThread.start();
                inputErrorThread.start();
                try {
                    inputStandardThread.join();
                    inputErrorThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                inputStd.close();
                inputErr.close();
            }
            catch (IOException err) {
                err.printStackTrace();
                return;
            }
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                this.postProcessNbest();
            }
            catch (Exception err) {
                err.printStackTrace();
                Parameters.reportLineFlush(err.getMessage());
                return;
            }
        }

        private void postProcessNbest() throws Exception {
            PrintWriter pw = FileUtil.getPrintWriter(this.outputBitParNbestPostProcessedThread);
            Scanner scan = FileUtil.getScanner(this.outputBitParNbestThread);
            if (!scan.hasNextLine()) {
                Parameters.reportLineFlush("EMPTY FILE!!!!");
                scan.close();
                return;
            }
            Iterator<String[]> originalTestIterator = null;
            String[] originalTestSentenceWords = null;
            originalTestIterator = this.originalTestSentencesWordsThread.iterator();
            originalTestSentenceWords = originalTestIterator.next();
            double lastReadProb = -1.0;
            TSNodeLabel tree = null;
            this.metricOptimizer.prepareNextSentence(originalTestSentenceWords);
            while (scan.hasNextLine()) {
                String line = scan.nextLine();
                if (line.equals("")) {
                    this.metricOptimizer.storeCurrentBestParseTrees();
                    if (!originalTestIterator.hasNext()) continue;
                    originalTestSentenceWords = originalTestIterator.next();
                    this.metricOptimizer.prepareNextSentence(originalTestSentenceWords);
                    continue;
                }
                if (line.charAt(0) == '(') {
                    line = line.replaceAll("\\\\", "");
                    try {
                        tree = new TSNodeLabel(line);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    tree = TSGparsingBitParFile.this.postProcessParseTree(tree);
                    pw.println(tree);
                    this.metricOptimizer.addNewDerivation(tree, lastReadProb);
                    continue;
                }
                if (line.startsWith("vitprob=")) {
                    lastReadProb = Double.parseDouble(line.substring(viterbProbPrefixLength));
                    pw.println(line);
                    continue;
                }
                if (line.startsWith("No parse for: ")) {
                    tree = TSGparsingBitParFile.this.dealWithNOParsedSentences(originalTestSentenceWords);
                    this.metricOptimizer.addNewDerivation(tree, lastReadProb);
                    pw.println(line);
                    continue;
                }
                System.out.println("Unknown line in bitpar output: " + line);
            }
            scan.close();
            pw.close();
        }

        protected class ReadErrorStream
        extends Thread {
            BufferedReader input;
            String reportPrefix;
            float parsingTime;

            public ReadErrorStream(BufferedReader input) {
                this.input = input;
                this.reportPrefix = "[stdErr_" + BitParThreadRunner.this.threadIndex + "]:";
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        if (line.equals("")) continue;
                        if (Character.isDigit(line.charAt(0))) {
                            TSGparsingBitParFile.this.doneWithOneSentence();
                            continue;
                        }
                        if (line.startsWith("reading") || line.startsWith("parameter") || line.startsWith("finished") || line.startsWith("raw")) continue;
                        Parameters.reportLineFlush(String.valueOf(this.reportPrefix) + line);
                    }
                }
                catch (IOException err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush(err.getMessage());
                    return;
                }
            }
        }

        protected class ReadInputStream
        extends Thread {
            BufferedReader input;
            String reportPrefix;

            public ReadInputStream(BufferedReader input) {
                this.input = input;
                this.reportPrefix = "[stdOut_" + BitParThreadRunner.this.threadIndex + "]:";
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        Parameters.reportLineFlush(String.valueOf(this.reportPrefix) + line);
                    }
                }
                catch (IOException err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush(err.getMessage());
                    return;
                }
            }
        }
    }
}

