from openpyxl import load_workbook, Workbook
import json
import os


def display_in_excel(data, file_name, titles=None, width=None):
    cols_map = {0: "A", 1: "B", 2: "C", 3: "D", 4: "E", 5: "F", 6: "G", 7: "H", 8: "I", 9: "J", 10: "K",
                11: "L", 12: "M", 13: "N", 14: "O", 15: "P", 16: "Q"}
    wb = Workbook()
    sheet = wb.active
    col_num = len(data[0])
    start_row = 1
    if titles:
        if len(titles) != col_num:
            print("column number inconsistent with titles")
    if width:
        if len(width) != col_num:
            print("column number inconsistent with width setting")
    if width:
        for i in range(col_num):
            # print("cols_map[i]", cols_map[i])
            sheet.column_dimensions[cols_map[i]].width = width[i]
    if titles:
        start_row += 1
        for i in range(col_num):
            sheet.cell(row=1, column=i + 1, value=titles[i])

    for i, single in enumerate(data):
        for j in range(col_num):
            try:
                if not isinstance(single[j], str):
                    print(single[j], "is not a string")
                    continue
                value = single[j]
                value = ''.join(c for c in value if valid_xml_char_ordinal(c))
                sheet.cell(row=start_row + i, column=j + 1, value=value)
            except Exception as e:
                print("display exception", e)
    try:
        wb.save(file_name)
    except Exception as e:
        print("excel utils: ", e)
        with open("excel_utils_temp_data.json", "w", encoding="utf-8") as fo:
            fo.write(json.dumps(data, ensure_ascii=False))
    
    
def read_excel_by_columns(file_path, start_row=1, end_row=-1, valid_cols=None, sheet_names=None):
    file_res = []
    if ".xlsx" not in file_path:
        print("not an excel file")
        return file_res
    wb = load_workbook(file_path)
    if not sheet_names:
        sheet_names = wb.sheetnames
    res = []
    for each in sheet_names:
        if each not in wb.sheetnames:
            print(each, "sheet not exist, ignore it")
            continue
        sheet = wb[each]
        min_rows = start_row
        max_rows = sheet.max_row
        min_cols = sheet.min_column
        max_cols = sheet.max_column
        if not valid_cols:
            valid_cols = [_ for _ in range(min_cols, max_cols + 1)]
        sheet_res = []
        for each_col in valid_cols:
            curr_col = []
            for each_row in range(min_rows, max_rows + 1):
                value = sheet.cell(each_row+1, each_col+1).value
                if not value or str(value) == "" or str(value).replace(" ", "") == "":
                    value = None
                value = str(value) if value else None
                curr_col.append(value)
            sheet_res.append(curr_col)
        res.append(sheet_res)
    return res


def read_excel(file_path, start_row=1, end_row=-1, valid_cols=None, sheet_names=None):
    file_res = []
    if ".xlsx" not in file_path:
        print("not an excel file")
        return file_res
    wb = load_workbook(file_path)
    if not sheet_names:
        sheet_names = wb.sheetnames
    for each in sheet_names:
        sheet_res = []
        if each not in wb.sheetnames:
            print(each, "sheet not exist, ignore it")
            continue
        sheet = wb[each]
        rows = sheet.rows
        if not valid_cols:
            valid_cols = [0]
        start_col = valid_cols[0]
        for i, row in enumerate(rows):
            if i < start_row or not row or not row[start_col] or not row[start_col].value or row[start_col].value == "":
                continue
            if end_row != -1 and i > end_row:
                continue
            row_res = []
            for j in valid_cols:
                if not row[j] or not row[j].value:
                    row_res.append(None)
                else:
                    row_res.append(row[j].value)
            sheet_res.append(row_res)
        file_res.append(sheet_res)
    return file_res


def save_to_json(data, file_path):
    with open(file_path, "w", encoding="utf-8") as fo:
        fo.write(json.dumps(data, ensure_ascii=False))


def dict2str_list(input_dict, res=""):
    for k, v in input_dict.items():
        if not isinstance(k, str):
            return None
        if isinstance(v, str):
            res += (k + ": " + v + "\n")
        elif isinstance(v, dict):
            res = dict2str_list(v, res)
        else:
            return None
    return res


def map_keys_in_dict(input_dict, keys_map):
    res = {}
    for k, v in input_dict.items():
        if not isinstance(k, str):
            return None
        if isinstance(v, str):
            if k not in keys_map:
                res[k] = v
            else:
                res[keys_map[k]] = v
        elif isinstance(v, dict):
            if k not in keys_map:
                res[k] = map_keys_in_dict(v, keys_map)
            else:
                res[keys_map[k]] = map_keys_in_dict(v, keys_map)
    return res


def valid_xml_char_ordinal(c):
    codepoint = ord(c)
    # conditions ordered by presumed frequency
    res = (0x20 <= codepoint <= 0xD7FF or codepoint in (0x9, 0xA, 0xD) or 0xE000 <= codepoint <= 0xFFFD or
           0x10000 <= codepoint <= 0x10FFFF)
    if not res:
        print(c)
    return res


def read_txt_from_file(filename):
    if not os.path.exists(filename):
        print("File does not exist")
        return None
    res = []
    with open(filename, 'r') as fi:
        for line in fi.readlines():
            if line.startswith('#'):
                continue
            res.append(line.strip())
    return "\n".join(res)


def save_txt_to_file(data, filename):
    with open(filename, 'w') as fo:
        fo.write(data)











