from ue4nlp.ue_estimator_mc import UeEstimatorMc

import logging

log = logging.getLogger(__name__)

def create_ue_estimator(
    model,
    ue_args,
    eval_metric,
    calibration_dataset,
    train_dataset,
    cache_dir,
    config=None,
):

    if ue_args.ue_type == "mc" or ue_args.ue_type == "mc-dc":
        return UeEstimatorMc(
            model, ue_args, eval_metric, calibration_dataset, train_dataset
        )
    else:
        raise ValueError()