#!/bin/bash

conda activate # load your conda environment
python --version

#!/bin/bash -l

# Base path to store the outputs.
BASE_PATH="../"

YAML_FILE="t5_supervised_large.yaml"

# Name of the project and experiment for wandb.
PROJECT_NAME="supervised_training"

# only gold data from Chat-GPT
EXPERIMENT_NAME="eval_gold_t5_only_gold_train_t5_base"
data_path="../../Dataset_release/"
test_data_path=${data_path}
path_to_save_output="run_" + ${EXPERIMENT_NAME} + ".txt"

# Wandb API key.
# WANDB_KEY=$(<wandb_key)
WANDB_KEY=""

# Wandb entity name.
WANDB_ENTITY=

# Create the directory to store the results.
mkdir -p $BASE_PATH/$PROJECT_NAME/$EXPERIMENT_NAME

path_to_save_output="train_model" + ${EXPERIMENT_NAME} + ".txt"

REWARD_FN=purity

WANDB_API_KEY=$WANDB_KEY python -u train_text_generation.py \
--base_path_to_store_results $BASE_PATH \
--config_path $YAML_FILE \
--project_name $PROJECT_NAME \
--experiment_name $EXPERIMENT_NAME \
--entity_name $WANDB_ENTITY \
--log_to_wandb --evaluate_bias \
--data_path ${data_path} --test_data_path ${test_data_path} \
--reward_fn_to_use ${REWARD_FN} --not_run_bfloat16 | tee $path_to_save_output
