from encoding_method import colors
from tqdm import tqdm
from prompt_template_class import OrderingGenerator
from langchain.prompts.chat import SystemMessagePromptTemplate, ChatPromptTemplate
from langchain import LLMChain
from langchain.chat_models import ChatOpenAI
from langchain.llms import OpenAI
from api_key import *
from output_parser import OrderingOutputParser
from data_creator import OrderingDataCreator
import argparse
from utlis import str2bool
import random
import numpy as np
from langchain.prompts import PromptTemplate
from utlis import load_llama, get_prompt, B_INST, E_INST

parser = argparse.ArgumentParser()
parser.add_argument("--num_examples", type=int, default=200)
parser.add_argument("--model_name", type=str, default="text-davin-003")
parser.add_argument("--few_shot", type=str2bool, default=True)
parser.add_argument("--cot", type=str2bool, default=False)
parser.add_argument("--multiple_run", type=str2bool, default=False)
args = parser.parse_args()
print(args)
#0.44 0.0 0.0 False False
#0.92 0.06 0.0 True False
#0.96 0.51 0 True True
ordering_creator = OrderingDataCreator(colors[:20])
prioritys, examples, unsorted_example, explanations = ordering_creator.create_inducting(num_examples=args.num_examples, num_partitions=1)
few_shot_prioritys, prioritys = prioritys[:5], prioritys[5:]
few_shot_examples, examples = examples[:5], examples[5:]
few_shot_explanations, explanations = explanations[:5], explanations[5:]
if "gpt-3.5" in args.model_name or "gpt-4" in args.model_name:
    llm = ChatOpenAI(model=args.model_name, openai_api_key=openai.api_key, temperature=0)
elif "llama" in args.model_name:
    args.model_name = "meta-llama/Llama-2-13b-chat-hf"
    llm = load_llama(args.model_name)
else:
    llm = OpenAI(model=args.model_name, openai_api_key=openai.api_key, temperature=0)
parser = OrderingOutputParser()
prompt_generator = OrderingGenerator()
meta_full_acc = []
meta_average_acc = []
meta_validation_acc = []
seed_list = [714, 123] if args.multiple_run == True else [714]
for seed in seed_list:
    random.seed(seed)
    few_shot_noised_examples = []
    for idx, priority in enumerate(few_shot_prioritys):
        if idx <= len(few_shot_prioritys) // 2:
            determinstic = "Clean"
        else:
            determinstic = "Noise"
        deleted_dict = prompt_generator.deleted_ruels(priority, determinstic=determinstic)
        few_shot_noised_examples.append(deleted_dict)
    acc_list = []
    validate_count = 0
    explanation_correct_count = 0
    explanation_total_count = 0
    full_explanation_correct_count = 0
    total_explanation_count = 0
    all_prompt = prompt_generator.ordering_rules_incorporating(few_shot_examples, few_shot_noised_examples,
                                                               few_shot_explanations, few_shot_prioritys,
                                                               chain_of_thought=args.cot, few_shot=args.few_shot)
    chat_prompt = ChatPromptTemplate.from_messages(all_prompt)
    if "gpt" in args.model_name or "davinci" in args.model_name:
        chain = LLMChain(llm=llm, prompt=chat_prompt)
    else:
        system = ""
        system += chat_prompt.messages[0].format(colors=str(colors[:20])).content
        instruction = ""
        example_idx = 0
        if len(chat_prompt.messages) > 2:
            for message in chat_prompt.messages[1:-1]:
                if message.additional_kwargs["name"] == "example_user":
                    if example_idx == 0:
                        instruction += message.format().content + " " + E_INST + " "
                    else:
                        instruction += "<s>" + B_INST + " " +message.format().content + " " +E_INST + " "
                    example_idx += 1
                elif message.additional_kwargs["name"] == "example_assistant":
                    instruction += message.format().content + " " + "</s>\\"+ "\n"
        system += "Additionally, please just output the answer with provided format and don't add any other explanation."
        instruction += chat_prompt.messages[-1].format(color_preference="{color_preference}",
                                                       OrderedLists="{OrderedLists}",
                                                       ).content
        template = get_prompt(instruction, system)
        prompt = PromptTemplate(template=template,
                                input_variables=["color_preference", "OrderedLists"])
        chain = LLMChain(prompt=prompt, llm=llm)

    for priority, example, explanation in tqdm(zip(prioritys, examples, explanations)):
        deleted_dict = prompt_generator.deleted_ruels(priority)
        example_text = prompt_generator.generate_multiple_example_text(example)
        color_preferece_text = prompt_generator.generate_preference_text(deleted_dict)
        if "gpt" in args.model_name or "davinci" in args.model_name:
            output = chain.run(colors=str(colors[:20]), OrderedLists=example_text, color_preference=color_preferece_text)
        else:
            output = chain.run(OrderedLists=example_text, color_preference=color_preferece_text)
        print(output)
        predicts, new_indudcted_rules, new_indudcted_dict = parser.parse_rule_incorporation(output)
        if deleted_dict != priority:
            explanation_total_count += 3
            total_explanation_count += 1
        if deleted_dict == priority and predicts == "No":
            validate_count += 1
        elif deleted_dict != priority and predicts == "Yes":
            validate_count += 1
            local_full_correct_count = 0
            for key in priority.keys():
                if key not in deleted_dict.keys() and key in new_indudcted_dict.keys():
                    if new_indudcted_dict[key] == priority[key]:
                        explanation_correct_count += 1
                        local_full_correct_count += 1
            if local_full_correct_count == 3 and len(new_indudcted_dict.keys()) == 3:
                full_explanation_correct_count += 1
    print(f"Validation Accuracy: {validate_count/len(prioritys)}")
    print(f"Explanation Accuracy: {explanation_correct_count/explanation_total_count}")
    print(f"Full Correct Accuracy: {full_explanation_correct_count/total_explanation_count}")
    print(f"---------------")
    meta_validation_acc.append(validate_count/len(prioritys))
    meta_average_acc.append(explanation_correct_count/explanation_total_count)
    meta_full_acc.append(full_explanation_correct_count/total_explanation_count)
for idx, validation_acc, average_acc, full_acc in zip(seed_list, meta_validation_acc, meta_average_acc, meta_full_acc):
    print(f"Validation Accuracy: {validation_acc}")
    print(f"Explanation Accuracy: {average_acc}")
    print(f"Full Explanation Accuracy: {full_acc}")
    print(f"------Seed {idx}------")
print(f"Meta Validation Accuracy: {np.mean(meta_validation_acc)}")
print(f"STD of Meta Validation Accuracy: {np.std(meta_validation_acc)}")
print(f"Meta Explanation Accuracy: {np.mean(meta_average_acc)}")
print(f"STD of Meta Explanation Accuracy: {np.std(meta_average_acc)}")
print(f"Meta Full Correct Accuracy: {np.mean(meta_full_acc)}")
print(f"STD of Meta Full Correct Accuracy: {np.std(meta_full_acc)}")


