/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.tregex.gui.FileTreeModel;
import edu.stanford.nlp.trees.tregex.gui.FileTreeNode;
import edu.stanford.nlp.trees.tregex.gui.TregexGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class FilePanel
extends JPanel {
    private static final long serialVersionUID = -2229250395240163264L;
    private static FilePanel filePanel = null;
    private JTree tree;
    private FileTreeModel treeModel;

    public static synchronized FilePanel getInstance() {
        if (filePanel == null) {
            filePanel = new FilePanel();
        }
        return filePanel;
    }

    private FilePanel() {
        FileTreeNode root = new FileTreeNode();
        this.treeModel = new FileTreeModel(root);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new FileTreeCellRenderer());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean canActivate;
                TreePath path = FilePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                int nActiveTreebanks = FilePanel.this.getActiveTreebanks().size();
                boolean bl = canActivate = !TregexGUI.getInstance().isTdiffEnabled() || nActiveTreebanks < 2;
                if (path != null) {
                    FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
                    if (canActivate || node.isActive()) {
                        node.setActive(!node.isActive());
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Tree files: "));
        JScrollPane scroller = new JScrollPane(this.tree);
        this.add((Component)scroller, "Center");
    }

    public void setTreeReaderFactory(TreeReaderFactory trf) {
        FileTreeModel.setTRF(trf);
    }

    public void loadFiles(EnumMap<TregexGUI.FilterType, String> filters, File[] files) {
        this.treeModel.addFileFolder(filters, files);
    }

    public boolean isEmpty() {
        return this.treeModel.isEmpty();
    }

    public void clearAll() {
        FilePanel filePanel = this;
        TreeReaderFactory oldTrf = filePanel.treeModel.getTRF();
        FileTreeNode root = new FileTreeNode();
        this.treeModel = new FileTreeModel(root);
        this.setTreeReaderFactory(oldTrf);
        this.tree.setModel(this.treeModel);
        this.revalidate();
        this.repaint();
    }

    public List<FileTreeNode> getActiveTreebanks() {
        ArrayList<FileTreeNode> active = new ArrayList<FileTreeNode>();
        this.setActiveTreebanksFromParent(active, this.treeModel.getRoot());
        return active;
    }

    private void setActiveTreebanksFromParent(List<FileTreeNode> active, FileTreeNode parent) {
        int numChildren = this.treeModel.getChildCount(parent);
        for (int i = 0; i < numChildren; ++i) {
            FileTreeNode child = this.treeModel.getChild(parent, i);
            if (!child.getAllowsChildren()) {
                if (!child.isActive()) continue;
                active.add(child);
                continue;
            }
            this.setActiveTreebanksFromParent(active, child);
        }
    }

    private static class FileTreeCellRenderer
    extends JCheckBox
    implements TreeCellRenderer {
        public FileTreeCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree t, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return ((FileTreeNode)value).getDisplay();
        }
    }
}

