theory question_40_0
imports Main

begin

typedecl entity
typedecl event

consts
  LightBulbs :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  LightEnergy :: "entity ⇒ bool"
  Convert :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  OtherEnergy :: "entity ⇒ bool"
  Energy :: "entity ⇒ bool"

(* Explanation 1: Some light bulbs convert electricity into light and heat energy. *)
axiomatization where
  explanation_1: "∃x. LightBulbs x ∧ (∃y z e. Electricity y ∧ LightEnergy z ∧ Convert e ∧ Agent e x ∧ Patient e y ∧ Patient e z)"

(* Explanation 2: Electrical energy is also energy. *)
axiomatization where
  explanation_2: "∀x. ElectricalEnergy x ⟶ Energy x"

theorem hypothesis:
  assumes asm: "LightBulbs x"
  (* Hypothesis: Some light bulbs convert other energy into light and heat energy. *)
  shows "∃x y z e. LightBulbs x ∧ OtherEnergy y ∧ LightEnergy z ∧ Convert e ∧ Agent e x ∧ Patient e y ∧ Patient e z"
proof -
  from asm have "LightBulbs x" by simp
  then obtain e where e: "Convert e ∧ Agent e x ∧ Patient e y ∧ Patient e z"
    using explanation_1 by blast
  then have "ElectricalEnergy y" using explanation_2 by blast
  then have "OtherEnergy y" by simp
  have conclusion: "Convert e ∧ Agent e x ∧ Patient e y ∧ Patient e z" using e by simp
  show ?thesis using asm conclusion `OtherEnergy y` `LightEnergy z` by blast
qed

end
