theory question_66_3

imports Main

begin

typedecl entity

consts
  Bartender :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Dressed :: "entity ⇒ entity ⇒ bool"
  Male :: "entity ⇒ bool"
  Black :: "entity ⇒ bool"
  AllBlack :: "entity ⇒ bool"
  SleevesRolledUp :: "entity ⇒ bool"
  Making :: "entity ⇒ entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  ADrink :: "entity ⇒ bool"
  MartiniGlass :: "entity ⇒ bool"

(* Explanation: A male bartender dressed in all black with his sleeves rolled up to elbow height is making a drink in a martini glass. *)
axiomatization where
  explanation: "∃x. Male x ∧ Bartender x ∧ Dressed x allBlack ∧ SleevesRolledUp x ∧ Making x aDrink ∧ In aDrink martiniGlass"

theorem hypothesis:
  (* Premise: A male bartender dressed in all black with his sleeves rolled up to elbow height is making a drink in a martini glass. *)
  assumes asm: "Male x ∧ Bartender x ∧ Dressed x allBlack ∧ SleevesRolledUp x ∧ Making x aDrink ∧ In aDrink martiniGlass"
  (* Hypothesis: A person is black. *)
  shows "∃x. Person x ∧ Black x"
proof -
  from asm have "Bartender x" by auto
  from asm have "Male x" by auto
  from asm have "Dressed x allBlack" by auto
  from explanation have "∃y. Bartender y ∧ Person y ∧ Dressed y allBlack" by fastforce
  from this(1) have "Person y" by auto
  from this(2) have "Dressed y allBlack" by auto
  from asm have "x = y" by simp
  from asm have "Black allBlack" by simp
  from asm have "In aDrink martiniGlass" by auto
  from asm have "Making x aDrink" by auto
  from asm have "aDrink ≠ None" by auto
  from asm have "MartiniGlass martiniGlass" by auto
  from asm have "Black martiniGlass" by auto
  from asm have "Black aDrink" by auto
  show ?thesis using `Person x` `Black allBlack` by blast
qed

end
