theory question_21_0

imports Main

begin

typedecl entity
typedecl event

consts
  Weathering :: "entity"
  Rocks :: "entity"
  SurfaceMaterials :: "entity"
  LargerWhole :: "entity"
  SmallerPieces :: "entity"
  IceWedging :: "event"
  MechanicalWeathering :: "event"
  Openings :: "entity"
  Expanding :: "event"
  Crack :: "entity"
  Water :: "entity"
  SolidState :: "entity"
  Liquid :: "entity"
  Freezing :: "event"
  ReducingHeatEnergy :: "event"
  Temperature :: "entity"
  HeatEnergy :: "entity"
  PropertyOfObjects :: "entity"
  Weather :: "event"
  OrderedValues :: "entity"
  Cold :: "entity"
  Cool :: "entity"
  Warm :: "entity"
  Hot :: "entity"
  ToLower :: "event"
  Decrease :: "event"
  ToReduce :: "event"
  MeasureOfHeatEnergy :: "entity"
  CyclesOfFreezingAndThawingWater :: "event"

Weathering(x) :- Rocks(y), SurfaceMaterials(z), LargerWhole(y), SmallerPieces(z), Agent(e, x), Patient(e, z).
IceWedging(x) :- MechanicalWeathering(y), Agent(e, x), Patient(e, y).
IceWedging(x) :- Openings(z), Expanding(e), Crack(z), Agent(e, x), Patient(e, z).
Water(x) :- SolidState(y), Ice(z), Temperatures(e), Agent(e, x), Patient(e, y).
Freezing(x) :- Liquid(y), ReducingHeatEnergy(e), Agent(e, x), Patient(e, y).
Temperature(x) :- HeatEnergy(y), PropertyOfObjects(z), Weather(e), OrderedValues(z), Cold(z1), Cool(z2), Warm(z3), Hot(z4), Agent(e, x), Patient(e, y).
Cold(x) :- LowInTemperature(y), Agent(e, x), Patient(e, y).
ToLower(x) :- Decrease(y), Agent(e, x), Patient(e, y).
ToReduce(x) :- Decrease(y), Agent(e, x), Patient(e, y).
MeasureOfHeatEnergy(x) :- Temperature(y), Agent(e, x), Patient(e, y).
CyclesOfFreezingAndThawingWater(x) :- IceWedging(y), Cause(z), Agent(e, x), Patient(e, y).

theorem hypothesis:
 assumes asm: ""
 shows ""
proof -
  1. We need to infer the hypothesis, so we need to find information about rocks, water, freezing, and breaking down. The action event of breaking down and the relationship of "what would most likely happen"
2. From the premise, we can get information about weathering and freezing.
3. Explanation 1 establishes that weathering means breaking down rocks into smaller pieces by weather.
4. Explanation 2 states that ice wedging is a kind of mechanical weathering.
5. Explanation 3 explains that ice wedging occurs when ice causes rocks to crack by expanding in openings.
6. Explanation 4 provides information about the temperature range for water to be in a solid state, called ice.
7. Explanation 5 states that water is a kind of liquid.
8. Explanation 6 defines freezing as changing from a liquid into a solid by reducing heat energy.
9. Explanation 7 provides information about temperature and heat energy being properties of objects, weather, and including ordered values of cold, cool, warm, hot.
10. Explanation 8 defines cold as low in temperature.
11. Explanation 9 states that to lower means to decrease.
12. Explanation 10 states that to reduce means to decrease.
13. Explanation 11 provides information about temperature being a measure of heat energy.
14. Explanation 12 establishes that cycles of freezing and thawing water cause ice wedging.
15. Using the information from explanation 2-12, we can deduce that when cold weather freezes water in the cracks of rocks, it is likely that the rocks will break into smaller pieces due to ice wedging.
  
qed

end
