theory question_54_0

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  TennisBall :: "entity ⇒ bool"
  Striking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Because :: "event ⇒ bool ⇒ bool"
  PlayingTennis :: "entity ⇒ bool"

(* Explanation 1: The man strikes the tennis ball because he is playing tennis. *)
axiomatization where
  explanation_1: "∃x y e. Man x ∧ TennisBall y ∧ Striking e ∧ Agent e x ∧ Patient e y ∧ Because e PlayingTennis x"

theorem hypothesis:
  (* Premise: A man in red and black about to strike a tennis ball. *)
  assumes asm: "Man x ∧ TennisBall y ∧ Striking e ∧ Agent e x ∧ Patient e y ∧ In e RedAndBlack x "
  (* Hypothesis: A man is playing tennis. *)
  shows "∃x e. Man x ∧ PlayingTennis e"
proof -
  from asm have "Man x" by blast
  from this have "PlayingTennis e" using explanation_1 by blast
  show ?thesis using `Man x` `PlayingTennis e` by blast
qed

end
