theory question_80_8
imports Main
begin

typedecl entity
typedecl event

consts
  ElectricalConductors :: "entity ⇒ bool"
  Include :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Copper :: "entity ⇒ bool"
  ElectricalConductor :: "entity ⇒ bool"
  Conduct :: "event ⇒ bool"
  Electricity :: "event ⇒ bool"

(* Explanation 1: Electrical conductors include copper. *)
axiomatization where
  explanation_1: "∀x e. ElectricalConductors x ∧ Include e ∧ Agent e x ⟶ Copper x"

(* Explanation 2: Copper, as an electrical conductor, can conduct electricity. *)
axiomatization where
  explanation_2: "∀x e. Copper x ∧ ElectricalConductor x ∧ Conduct e ∧ Agent e x ⟶ Electricity e"  

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Materials x ∧ ElectricalConductors x"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x e. Copper x ∧ Conduct e ∧ Agent e x ∧ Electricity e"
proof -
  from asm have "ElectricalConductors x" by simp
  then have "Copper x" using explanation_1 by blast
  then obtain e where e: "Conduct e ∧ Agent e x" using explanation_2 by blast
  have "Electricity e" using explanation_2 `Copper x` by blast
  show ?thesis using `Copper x` e `Electricity e` by blast
qed

end
