theory question_74_1
imports Main

begin

typedecl entity
typedecl event

consts
  Fibres :: "entity ⇒ bool"
  Paper :: "entity ⇒ bool"
  Trees :: "entity ⇒ bool"
  Pulping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Require :: "event ⇒ bool"
  NonWoodFibres :: "entity ⇒ bool"
  Pulped :: "event ⇒ bool"
  Saves :: "event ⇒ bool"

(* Explanation 1: Pulping fibres for paper does not require cutting down trees. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ ¬(Require e2 ∧ Agent e2 x ∧ Patient e2 z)"

(* Explanation 2: Dozens of non-wood fibers are pulped for paper around the world. *)
axiomatization where
  explanation_2: "∀x y e. NonWoodFibres x ∧ Paper y ∧ Pulped e ∧ Agent e x ∧ Patient e y"  

theorem hypothesis:
  assumes asm: "Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y"
  (* Hypothesis: Pulping fibres for paper saves trees. *)
  shows "∃x y z e1 e2. Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Saves e2 ∧ Agent e2 x ∧ Patient e2 z"
proof -
  from asm have "Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y" by simp
  then have "¬(Require e2 ∧ Agent e2 x ∧ Patient e2 z)" using explanation_1 by blast
  then have "NonWoodFibres x ∧ Paper y ∧ Pulped e ∧ Agent e x ∧ Patient e y" using explanation_2 by blast
  then have "Saves e2 ∧ Agent e2 x ∧ Patient e2 z" using explanation_1 by blast
  show ?thesis using asm `Saves e2 ∧ Agent e2 x ∧ Patient e2 z` by blast
qed

end
