﻿using System;

namespace SpreadsheetLLM.Heuristic
{
    internal struct Boundary : IComparable<Boundary>
    {
        public int top, bottom, left, right;

        public Boundary(int up, int down, int left, int right)
        {
            this.top = up;
            this.bottom = down;
            this.left = left;
            this.right = right;
        }

        public int this[int index]
        {
            get
            {
                switch (index)
                {
                    case 0: return top;
                    case 1: return bottom;
                    case 2: return left;
                    case 3: return right;
                    default: throw new ArgumentOutOfRangeException(nameof(index));
                }
            }
            set
            {
                switch (index)
                {
                    case 0: top = value; return;
                    case 1: bottom = value; return;
                    case 2: left = value; return;
                    case 3: right = value; return;
                    default: throw new ArgumentOutOfRangeException(nameof(index));
                }
            }
        }

        public int CompareTo(Boundary other)
        {
            if (this.top != other.top)
                return this.top.CompareTo(other.top);
            else if (this.bottom != other.bottom)
                return this.bottom.CompareTo(other.bottom);
            else if (this.left != other.left)
                return this.left.CompareTo(other.left);
            else
                return this.right.CompareTo(other.right);
        }

        public override string ToString()
        {
            return top + (top == bottom ? "" : $"[+{bottom - top}]") + "," + left + (left == right ? "" : $"[+{right - left}]");
        }
    }
}
