from typing import Deque, List, Optional,Tuple
from aiwolf import Agent
from Villager import ddhbVillager
import openai
import time
import os
import copy
import json
from retry import retry
# openai.api_keyにOpenAIのAPIキーを入れる
openai.api_key = os.environ['OPENAI_API_KEY']
gpt4="gpt-4-1106-preview"
gpt3="gpt-3.5-turbo-1106"
#langchain
from langchain.prompts import PromptTemplate
from langchain.chat_models import ChatOpenAI
from langchain.chains import LLMChain
from pydantic.v1 import BaseModel, Field

class GptAgent:
    """A character with memory and innate characteristics."""
    observation_rule: str
    """The traits of the character you wish not to change."""
    #status: str
    """Current activities of the character."""
    gpt4="gpt-4-1106-preview"
    gpt3="gpt-3.5-turbo-1106"

    """The retriever to fetch related memories."""
    #verbose: bool = False

    #reflection_threshold: Optional[float] = None
    """When the total 'importance' of memories exceeds the above threshold, stop to reflect."""

    current_plan: List[str] = []
    belief: str = ""
    pattern: str = ""
    long_belief: str = ""
    counter_belief: str = ""
    plan: str = ""
    high_plan: str = ""
    """The current plan of the agent."""

    memory: List = ['']
    summary: str = ""  #: :meta private:
    summary_refresh_seconds: int = 3600  #: :meta private:

    memory_importance: float = 0.0  #: :meta private:
    max_tokens_limit: int = 1200  #: :meta private:
    read_observation: str = ""  #: :meta private:

    rule:str = ""  #: :meta private:
    my_role:str

    def __init__(self) -> None:
        """Initialize a new instance of ddhbVillager."""
        self.observation_rule=""
        self.current_plan=[]
        self.belief=""
        self.pattern=""
        self.long_belief=""
        self.counter_belief=""
        self.plan=""
        self.high_plan=""
        self.memory=[""]
        self.summary=""
        self.summary_refresh_seconds=3600
        self.read_observation=""
        self.rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,裏切者:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                裏切者:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。"""
        self.my_role=None





    class Config:
        """Configuration for this pydantic object."""

        arbitrary_types_allowed = True


        

    
    
    def add_long_memory(self, memory_content: str) -> List[str]:
        """Add an observation or memory to the agent's memory."""
        self.memory.append(memory_content)
        return  self.memory


 

    #@retry()
    def planning(self,my_id:int,my_role:str,observation: str, belief: str =None, valid_action_list: List[str] = None, short_memory_summary:str = "",pattern:str = "",last_plan:str = "") -> str:
        # OpenAIのモデルのインスタンスを作成
        chat = ChatOpenAI(model_name=gpt3, temperature=1.0,request_timeout=30)

        prompt = PromptTemplate.from_template(
                "あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n"
            + " ゲームルール:{rule} \n"
            +"あなたの役職:{my_role}\n"
            +"{pattern}\n"
              +"現在のゲーム状況に関するあなたの見解:{observation}\n"
            +"{belief}\n"
            +"与えられた情報をすべて理解した上で、以下のことができるか:"
            +"合理的な計画を立てる:人狼ゲームで最終的に勝利するために、今できる行動{valid_action_list}に従って、いくつかの戦略を段階的に計画してください。"
                 +"各プランの勝率/負け率/引き分け率の予測:与えられた情報と人狼に関するあなたの知識を理解したうえで、現在のゲームにおける各プランの各ステップの成功率と、各プラン/戦略の全体的な平均勝敗(合計で100%になるように正規化)をテンプレートに従ってステップごとに推定してください。:プラン1を実行した場合、自分の{my_role}という役職と公開情報(正しいとは限らない)と勝敗ルールから、勝つか負けるか(確率);...continue...全体的な勝敗率:分析に基づき、加重平均を段階的に行うことで、全体の勝率(確率)、負け率(確率)を得る。"
                +"プランの選択:すべてのプランについて勝率、戦略改善との両方を考慮して、最も勝率の高いプラン/戦略を選択してください。"
            )


        agent_summary_description = short_memory_summary
       
        belief = self.belief if belief is None else belief
      
        kwargs = dict(
            
            my_id=my_id,
            recent_observations=agent_summary_description,
            last_plan=last_plan,
            belief=belief,
            pattern=pattern,
            observation=observation,
            rule=self.rule,
            valid_action_list=valid_action_list,
            my_role=my_role
        )


        plan_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        plan = plan_prediction_chain.run(**kwargs)
        plan = plan.strip()

        print(plan.strip())
        return plan.strip()
    
    #@retry()
    def get_belief(self, my_id:int,my_role:str,observation: str, short_memory_summary:str,pattern:str = "") -> str:
        chat = ChatOpenAI(model_name=gpt3, temperature=1.0,request_timeout=30)
        "React to get a belief."
        prompt = PromptTemplate.from_template(
            "あなたはAgent[{my_id}]というプレイヤーで5人で人狼というゲームをプレイしています。\n"
            +"あなたの役職は{my_role}です。"
            +"ゲームルール:{rule}"
            +"ほかのプレイヤーの行動パターンと改善された戦略に関するあなたの推定判断は{pattern}\n"
            +"あなたの現在の観察:{observation}\n"
            +"ほかのプレイヤーとの行動や会話を含むあなたの現在のゲーム進行状況の要約は次の通り:{recent_observations}\n"
            +"ゲームルール、あなたの役職、監察結果、現在のゲームの進行状況、ほかのプレイヤーの推定行動パターン、人狼に関するあなたの知識を理解したうえで次のことをしてください。"
            +"自身の発言の分析:与えられた情報をすべて理解したうえで、現在のターンにおけるあなたの最適な発言と行動を分析してください。"
            +"ほかのプレイヤーを信じる:与えられた情報をすべて理解したうえでほかのプレイヤーの役職に関する確率を段階的に推測してください。(合計が100%になるように正規化)"
            )
        agent_summary_description = short_memory_summary

        kwargs = dict(
            my_id=my_id,
            my_role=my_role,
            agent_summary_description=agent_summary_description,
            recent_observations=agent_summary_description,
            pattern= pattern,
            observation=observation,
            rule=self.rule

        )
        
        belief_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        self.belief = belief_prediction_chain.run(**kwargs)
        self.belief = self.belief.strip()
        print(self.belief.strip())
        return self.belief.strip()
    
    #@retry()
    def get_pattern(self, my_id:int,my_role:str,game_pattern: str='', last_k:int=20,short_summarization:str='') -> str:
        chat = ChatOpenAI(model_name=gpt3, temperature=1.0,request_timeout=30)
        "React to get a belief."
        prompt = PromptTemplate.from_template(
            "あなたはAgent[{my_id}]というプレイヤーで、5人で人狼というゲームをプレイしています。\n"
            +"あなたの役職:{my_role}\n"
            +"ゲームルール:{rule}\n"
            +"あなたの過去のゲーム記憶には、ほかプレイヤーとの観察、行動、会話が含まれます:{long_memory}\n"
            +"ゲームルール、これまでのゲーム履歴、人狼に関する知識を理解し、今後のゲームで次のことをしてください。"
            +"発言の理由:これまでのゲームでなぜそのような発言をしたのか考えてください。"
            +"正当性:これまでのゲームでどの行動が正しかったか、間違っていたかを考えてください。"
            +"戦略の改善:上記の情報を理解したうえで、勝つためにはどのような戦略をとればよいか段階的に考えてください。(ゲーム中に相手の役職、投票対象は観察できないが、相手の発言は観察することができることに注意)ツリー構造として出力。"
            )
        reflection_chain = LLMChain(llm=chat, prompt=prompt, verbose=self.verbose)
        long_memory = self.memory[-last_k:]
        long_memory_str = "\n\n".join([o for o in long_memory])
        
        kwargs = dict(
            my_id=my_id,
            my_role=my_role,
            long_memory=long_memory_str,
            game_pattern=game_pattern,
            rule=self.rule

        )
        # print(kwargs)

        self.long_belief = reflection_chain.run(**kwargs)
        self.long_belief = self.long_belief.strip()
        print(self.long_belief.strip())
        return self.long_belief.strip()
    
    #@retry()
    def get_summarization(self, recipient_name: str,game_memory: str, opponent_name:str,no_highsight_obs:bool) -> str:
        chat = ChatOpenAI(model_name=gpt3, temperature=1.0,request_timeout=30)
        """Get a long memory summarization to save costs."""
        prompt = PromptTemplate.from_template(
            "あなたはAgent[{my_id}]というプレイヤーで、5人で人狼というゲームをプレイしています。\n"
            +"あなたの役職:{my_role}\n"
            +"ゲームルール:{rule}\n"
            +"観察変換ルール:{observation_rule}\n"
            +"ほかプレイヤーとの観察、行動、会話を含むゲーム履歴:{long_memory}\n"
            +"ゲームルール、観察変換ルール、ゲーム履歴、人狼に関する知識を理解したうえで、次のことをしてください。"
            +"履歴の要約:行動のゲーム履歴、観戦、結果情報をテンプレートを使って要約し短時間で回答する:最初のゲームのターンでプレイヤーは発言をし、...continue..."
            )       
        reflection_chain = LLMChain(llm=chat, prompt=prompt, verbose=self.verbose)
        kwargs = dict(
            observation_rule=self.observation_rule,
            long_memory=game_memory,
            agent_name=self.name,
            recipient_name=recipient_name,
            opponent_name=opponent_name,
            # observation=observation,
            game_name=self.game_name,
            rule=self.rule

        )
        # print(kwargs)

        self.long_belief = reflection_chain.run(**kwargs)
        self.long_belief = self.long_belief.strip()
        print(self.long_belief.strip())
        return self.long_belief.strip()
    
    #@retry()
    def get_short_memory_summary(self, my_id:int ,my_role:str,observation: str,short_memory_summary:str) -> str:
        chat = ChatOpenAI(model_name=gpt3, temperature=1.0,request_timeout=30)
        """React to get a belief."""
        prompt = PromptTemplate.from_template(
            "あなたはAgent[{my_id}]というプレイヤーで、5人で人狼というゲームをプレイしています。\n"
            +"あなたの役職:{my_role}\n"
            +"ゲームルール:{rule}\n"
            +"現在の観察:{observation}\n"
            +"以前の行動、観察、会話を含む現在のゲーム履歴:{agent_summary_description}\n"
            +"ゲームルール、あなたの観察、人狼に関する知識に基づいて現在の履歴を要約してください。ツリー構造で出力してください。"
        )

        agent_summary_description = short_memory_summary
    
        kwargs = dict(
            my_id=my_id,
            my_role=my_role,
            agent_summary_description=agent_summary_description,
            recent_observations=agent_summary_description,
            observation=observation,
            rule=self.rule
        )

        belief_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        self.belief = belief_prediction_chain.run(**kwargs)
        self.belief = self.belief.strip()
        print(self.belief.strip())
        return self.belief.strip()
    

    #@retry()
    def convert_obs(self, my_id: str, my_role: str, observation: str, valid_action_list: str) ->  str:
        chat = ChatOpenAI(model_name=gpt3, temperature=1.0,request_timeout=30)
        """React to get a belief."""
        prompt = PromptTemplate.from_template(
            "あなたはAgent[{my_id}]というプレイヤーで、5人で人狼というゲームをプレイしています。\n"
            +"あなたの役職:{my_role}\n"
            +"ゲームルール:{rule}\n"
            +"現在の観察:{observation}\n"
            +"あなたの有効なアクションリスト:{valid_action_list}\n"
            +"観察変換ルール:{observation_rule}\n"
            +"観察変換ルールと人狼に関する知識に基づいて{observation}と{valid_action_list}を読みやすい文章に変換してください。"
            )
        kwargs = dict(
            my_id=my_id,
            my_role=my_role,
            rule=self.rule,
            observation=observation,
            valid_action_list=valid_action_list,
            game_name=self.game_name,
            observation_rule=self.observation_rule
        )
        obs_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        self.read_observation = obs_prediction_chain.run(**kwargs)
        self.read_observation = self.read_observation.strip()
        print(self.read_observation)
        return self.read_observation
    

    #@retry()
    def action_decision(self, observation: str, valid_action_list: List[str], promp_head: str, act: str = None,short_memory_summary:str="") -> Tuple[str,str]:
        chat = ChatOpenAI(model_name=gpt3, temperature=1.0,request_timeout=30)
        """React to a given observation."""
        """React to a given observation."""
        prompt = PromptTemplate.from_template(
            promp_head
            +"\nあなたのプラン:{plan}"
            +"\nプランに基づき、次のアクションをアクションリストから選択してください。:{valid_action_list},最終的に勝利してください。応答を|で分割してください。"
            +"\n\n"
        )

        agent_summary_description = short_memory_summary

        kwargs = dict(
            agent_summary_description= agent_summary_description,
            # current_time=current_time_str,
            # relevant_memories=relevant_memories_str,
            agent_name= self.name,
            game_name=self.game_name,
            observation= observation,
            agent_status= self.status,
            valid_action_list = valid_action_list,
            plan = self.plan,
            belief = self.belief,
            act = act
        )
        action_prediction_chain = LLMChain(llm=chat, prompt=prompt)

        result = action_prediction_chain.run(**kwargs)
        if "|" in result:
            result,result_comm = result.split("|",1)
        else:
            result_comm = ""
        print(result.strip,result_comm.strip())
        return result.strip(),result_comm.strip()
    

    #@retry()
    def make_act(self, observation: str, my_id: int, my_role: str, valid_action_list: List, bot_short_memory:List, bot_long_memory:List, turn: int) -> Tuple[bool, str]:
        readable_text_amy_obs = self.convert_obs(my_id,my_role,observation, valid_action_list)
                   
        time.sleep(0)
        if len(bot_short_memory[my_id]) == 1:
            short_memory_summary = f'{1}th Game Start \n'+readable_text_amy_obs
        else:
            short_memory_summary = self.get_short_memory_summary(my_id,my_role,observation=readable_text_amy_obs, short_memory_summary='\n'.join(bot_short_memory[my_id]))

        time.sleep(0)
        if  turn <= 1:
                self.pattern = self.get_pattern(my_id,my_role,'',short_summarization=short_memory_summary)        

        
        belief = self.get_belief(my_id,my_role,readable_text_amy_obs,short_memory_summary=short_memory_summary,pattern=self.pattern)
                

        time.sleep(0)
        self.plan = self.planning(my_id,my_role,readable_text_amy_obs, belief=belief,valid_action_list=valid_action_list,short_memory_summary=short_memory_summary,pattern=self.pattern,last_plan='')
            
        time.sleep(0)
        promp_head = ''
        act, comm = self.action_decision(readable_text_amy_obs, valid_action_list, promp_head,short_memory_summary=short_memory_summary)
 

        while act not in valid_action_list:
            print('Action + ', str(act), ' is not a valid action in valid_action_list, please try again.\n')
            promp_head += 'Action {act} is not a valid action in {valid_action_list}, please try again.\n'
            act, comm = self.action_decision( readable_text_amy_obs, valid_action_list, promp_head,act)

        bot_short_memory[my_id].append(f"{self.name} have the observation {readable_text_amy_obs}, try to take action: {act} and say {comm} to")
        bot_short_memory[((my_id + 1)%2)].append(f"{self.name} try to take action: {act} and say {comm} to ")

        bot_long_memory[my_id].append(
            f"{self.name} have the observation {observation}, try to take action: {act} and say {comm} to ")
        return act,comm,bot_short_memory,bot_long_memory
    
if __name__=="__main__":
    observation="""Day01 00[000]   Agent[04]       「昨晩は静かな夜で何も起こらなかったね、まずはお互いに情報を開示して信頼を築くことが大切だと思うよ。」
Day01 00[001]   Agent[02]       「皆さん、おはようございます。信頼を築くためにも自己紹介をしましょう。私はただの村人ですが、一緒に人狼を見つけ出しましょう。」
Day01 00[002]   Agent[03]       「こんにちは、皆さん。私は占い師を役職としており、今夜はAgent[02]を占い、その結果は人間であると判定されましたので共有させていただきます。」
Day01 00[003]   Agent[01]       「こんにちは皆さん、私も村人です。占いの結果が真実か見極めるため、今後の発言や行動に注目しましょう。」
Day01 00[004]   Agent[05]       「昨夜は何も起こらなかったようですね。私もみなさんと同じく村人の一員です。今夜は特に注意深く互いの行動を見守りたいと思います。」
Day01 01[005]   Agent[01]       「皆さんの意見に同意します。私は村人ですが、発言や行動を注意深く見て、人狼と裏切者を見抜く手助けができればと思います。」
Day01 01[006]   Agent[04]       「朝からAgent[03]の占い結果が真実かどうかは疑わしいですね、人狼側が先手を打って占い師を装っている可能性もあるから、みんなはその点を念頭に置いて発言や行動を見てほしい。」      
Day01 01[007]   Agent[02]       「Agent[03]の占い結果に感謝します。これからはお互いの発言の真意を探りながら、疑わしい行動を取る人がいないか警戒していきましょう。」
Day01 01[008]   Agent[05]       「皆さんの発言に感謝します。Agent[03]が示した占い結果を元に、村の安全を守りつつ、人狼を見つけ出す手がかりを探しましょう。」
Day01 01[009]   Agent[03]       「皆さん、私が占い師であり、今夜はAgent[04]を占いますので、どうぞよろしくお願いします。」
Day01 02[010]   Agent[04]       「占い結果を信じつつも、私たちは裏切者の存在も忘れてはならないので、軽率な判断は避け、情報をじっくり分析することが大切だと考えます。」
Day01 02[011]   Agent[01]       「昨晩は特に事件もなく、Agent[03]が占い師を名乗りAgent[02]を人間だと占ったことを受け、これからの行動で信頼性を見極めたいと思います。」
Day01 02[012]   Agent[03]       「皆さん、昨夜占った結果を報告します。Agent[05]を占いましたが、結果は人間でした。これを踏まえて、疑わしい行動をしているエージェントを見極めましょう。」
Day01 02[013]   Agent[05]       「皆さん、ありがたいことにAgent[03]が私を占ってくれて人間と判定されたようですが、冷静に状況を見極めながら、違和感を感じた点について積極的に議論を進めていきましょう。」        
Day01 02[014]   Agent[02]       「昨晩の占い結果を踏まえ、今日は皆さんの発言と行動を慎重に観察し、矛盾が無いか確認したいと思います。」
Day01 03[015]   Agent[05]       「確かにAgent[03]が占い師かどうかはまだ不確かですが、私が人間と判定されたことに感謝します。今は全員が信用できるとは限らないので、一歩一歩慎重に情報を共有し、真実に近づけるよう努力しましょう。」
Day01 03[016]   Agent[04]       「Agent[03]が占い師と名乗っていますが、もし人狼側の方だとすれば、私たちは誤った情報に基づいて判断を下す危険性があります。真実を見極めるためにも、他のエージェントの発言と行動を注意深く見る必要がありますね。」
Day01 03[017]   Agent[03]       「皆さん、私が真の占い師であるAgent[03]です。他のエージェントの誤った主張に注意し、正しい情報を共有するためにも昨夜の占い結果を正式に伝えます。私は昨晩Agent[01]を占い、その結 果は人間であると判定されました。この情報を信じて、一緒に人狼を見つけ出しましょう。」
Day01 03[018]   Agent[02]       「Agent[03]が占い師だと自称していますが、一晩で三人を占うとは不自然ですし、一人しか占えないはずなので、その矛盾を明らかにしましょう。」
Day01 03[019]   Agent[01]       「Agent[03]の占い結果に疑問を感じています。占い師は一夜につき一人しか占えないはずですので、今回の占い結果については議論を深めるべきだと思います。」"""

    my_id=str(1)
    my_role="村人"
    valid_action_list=["DUMMY","ESTIMATE","COMINGOUT","DIVINATION","DIVINED","IDENTIFIED","GUARD","GUARDED","VOTE","VOTED","ATTACK","ATTACKED","AGREE","DISAGREE"]
    short=[]
    long=[]
    game=1
    turn=1
    print(GptAgent.convert_obs(my_id, my_role, observation, valid_action_list,short))
    print(GptAgent.make_act(observation,my_id,my_role,valid_action_list,short,long,game,turn))




    


