import csv
import re
from transformers import pipeline, set_seed

data = []
with open("data-augmentation-for-trec/data/labeled.tsv") as file:
    tsv_file = csv.reader(file, delimiter="\t")
    for line in tsv_file:
        data.append(line[0])
data = data[1:]

split_data = []
for i in range(len(data)):
  split_data.append(data[i].split(" ", 1))

print("Example of data:", split_data[0])

generator = pipeline('text-generation', model='gpt2')

# Single sentence aug
syn_data = []

# 9 (low-resource) or 2 (half)
num = 1

for i in range(len(split_data)):
  txt = split_data[i][1]
  new_txt = generator(txt, max_length=20, num_return_sequences=num)
  for j in range(num):
    tmp = re.sub('[^A-Za-z0-9]+', ' ', new_txt[j]['generated_text'])
    syn_data.append(split_data[i][0]+' '+tmp)

syn_data = syn_data + data

print("size of train data:", len(split_data))
print("size of augmented data:", len(syn_data))

with open("data-augmentation-for-trec/aug_data/labeled.tsv", "w") as file:
  writer = csv.writer(file)
  writer.writerow(["fine_label utterance"])


with open("data-augmentation-for-trec/aug_data/labeled.tsv", "a") as file:
  writer = csv.writer(file, delimiter='\n', quotechar='', quoting=csv.QUOTE_NONE)
  writer.writerow(syn_data)

