import json
import os
import shutil
from typing import List
from hedal import NumColumn

def norm_meta_path(input: NumColumn, meta_name: str = "norm_metadata.json") -> str:
    return input.metadata_path.parent / meta_name

def copy_norm_meta(input: NumColumn, output: NumColumn) -> None:
    shutil.copyfile(
        input.metadata_path.parent / "norm_metadata.json", output.metadata_path.parent / "norm_metadata.json"
    )

def save(input: NumColumn, m_info: json) -> None:
    with open(norm_meta_path(input), "w") as m_file:
        json.dump(m_info, m_file)

def set_norm_type(input: NumColumn, norm_type: str) -> None:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["norm_type"] = norm_type
    save(input, m_file)

def get_norm_type(input: NumColumn) -> str:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
            return m_file["norm_type"]
    else:
        return print(f"[Error] No norm_metadata.json for {input.name}")

def set_norm_plus(input: NumColumn, list_plus: List) -> None:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["norm_plus"] = list_plus
    save(input, m_file)

def get_norm_plus(input: NumColumn) -> List:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
            return m_file["norm_plus"]
    else:
        return print(f"[Error] No norm_metadata.json for {input.name}")

def set_norm_minus(input: NumColumn, list_minus: List) -> None:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["norm_minus"] = list_minus
    save(input, m_file)

def get_norm_minus(input: NumColumn) -> List:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
            return m_file["norm_minus"]
    else:
        return print(f"[Error] No norm_metadata.json for {input.name}")

def set_norm_factor(input: NumColumn, norm_factor: int) -> None:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["norm_factor"] = norm_factor
    save(input, m_file)

def get_norm_factor(input: NumColumn) -> int:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
            return m_file["norm_factor"]
    else:
        return print(f"[Error] No norm_metadata.json for {input.name}")

def set_norm_size(input: NumColumn, norm_size: int) -> None:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["norm_size"] = norm_size
    save(input, m_file)

def get_norm_size(input: NumColumn) -> int:
    if os.path.isfile(norm_meta_path(input)):
        with open(norm_meta_path(input), "r") as m_file:
            m_file = json.load(m_file)
            return m_file["norm_size"]
    else:
        return print(f"[Error] No norm_metadata.json for {input.name}")


# NCP용
def ncp_meta_path(input_ctxt: str, meta_name: str = "ncp_metadata.json") -> str:
    return input_ctxt + "/" + meta_name


def copy_ncp_meta(input_ctxt: str, output_ctxt: str) -> None:
    shutil.copyfile(
        input_ctxt + "/ncp_metadata.json", output_ctxt + "/ncp_metadata.json"
    )

def save_ncp(input_ctxt: str, m_info: json) -> None:
    with open(ncp_meta_path(input_ctxt), "w") as m_file:
        json.dump(m_info, m_file)

def set_ncp_header(input_ctxt: str, header: List) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["header"] = header
    save_ncp(input_ctxt, m_file)

def get_ncp_header(input_ctxt: str,) -> List:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "header" in m_file:
                return m_file["header"]
            else:
                return list()
    else:
        return list()

def set_ncp_num_rows(input_ctxt: str, num_rows: int) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["num_rows"] = num_rows
    save_ncp(input_ctxt, m_file)

def get_ncp_num_rows(input_ctxt: str) -> int:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "num_rows" in m_file:
                return m_file["num_rows"]
            else:
                return list()
    else:
        return print(f"[Error] No metadata.json")

def set_ncp_num_slots(input_ctxt: str, num_slots: int) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["num_slots"] = num_slots
    save_ncp(input_ctxt, m_file)

def get_ncp_num_slots(input_ctxt: str) -> int:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "num_slots" in m_file:
                return m_file["num_slots"]
            else:
                return list()
    else:
        return print(f"[Error] No metadata.json")

def set_ncp_packing_type(input_ctxt: str, packing_type: str) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["packing_type"] = packing_type
    save_ncp(input_ctxt, m_file)

def get_ncp_packing_type(input_ctxt: str) -> str:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "packing_type" in m_file:
                return m_file["packing_type"]
            else:
                return list("Columnwise")
    else:
        return print(f"[Error] No metadata.json")

def set_ncp_result_column(input_ctxt: str, result_col_names: List) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["result_col_names"] = result_col_names
    save_ncp(input_ctxt, m_file)

def get_ncp_result_column(input_ctxt: str) -> List:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "result_col_names" in m_file:
                return m_file["result_col_names"]
            else:
                return list()
    else:
        return list()

def set_ncp_bin_column(input_ctxt: str, bin_col_names: List) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["bin_col_names"] = bin_col_names
    save_ncp(input_ctxt, m_file)

def get_ncp_bin_column(input_ctxt: str) -> List:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "bin_col_names" in m_file:
                return m_file["bin_col_names"]
            else:
                return list()
    else:
        return list()

def set_ncp_bin_num_list(input_ctxt: str, bin_col_names: List) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}

    bin_num_lists = list()
    for col_name in bin_col_names:
        hedal_meta_path = input_ctxt + "/" + col_name + "/metadata.json"
        if os.path.isfile(hedal_meta_path):
            with open(hedal_meta_path, "r") as hedal_file:
                hedal_file = json.load(hedal_file)
        else:
            raise Exception(f"[Error] No metadata for {col_name}.")
        bin_num = hedal_file["col_names"]
        input_bin_num = col_name + ":"
        for idx in range(len(bin_num)):
            if idx == len(bin_num)-1:
                input_bin_num += bin_num[idx]
            else:
                input_bin_num += bin_num[idx] + ","
        bin_num_lists.append(input_bin_num)
    m_file["bin_num_lists"] = bin_num_lists
    save_ncp(input_ctxt, m_file)

def get_ncp_bin_num_list(input_ctxt: str) -> List:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "bin_num_lists" in m_file:
                return m_file["bin_num_lists"]
            else:
                return list()
    else:
        return list()

def set_ncp_num_epoch(input_ctxt: str, num_epoch: int) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["num_epoch"] = num_epoch
    save_ncp(input_ctxt, m_file)

def get_ncp_num_epoch(input_ctxt: str) -> int:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "num_epoch" in m_file:
                return m_file["num_epoch"]
            else:
                return list()
    else:
        return list()

def set_ncp_learning_rate(input_ctxt: str, learning_rate: float) -> None:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
    else:
        m_file = {}
    m_file["learning_rate"] = learning_rate
    save_ncp(input_ctxt, m_file)

def get_ncp_learning_rate(input_ctxt: str) -> float:
    if os.path.isfile(ncp_meta_path(input_ctxt)):
        with open(ncp_meta_path(input_ctxt), "r") as m_file:
            m_file = json.load(m_file)
            if "learning_rate" in m_file:
                return m_file["learning_rate"]
            else:
                return list()
    else:
        return list()

