import os
from pathlib import Path

_secretkey_file_name: str = "secretkey.bin"


class KeyPack:
    @staticmethod
    def load_public_key(context, path: str):
        return context.heaan.KeyPack(context.context, f"{path}")

    @staticmethod
    def load_secret_key(context, path: str):
        sk_path = f"{path}/{_secretkey_file_name}"
        sk = context.heaan.SecretKey(context.context, sk_path)
        return sk

    @staticmethod
    def generate_secret_key(context, path: str):
        path_ = Path(path)
        if not path_.exists():
            os.makedirs(path, mode=0o775, exist_ok=True)
        sk = context.heaan.SecretKey(context.context)
        sk.save(str(path_ / _secretkey_file_name))

    @staticmethod
    def generate_public_key(context, sk_path: str, pk_path: str):
        sk_path_, pk_path_ = Path(sk_path), Path(pk_path)
        if not pk_path_.exists():
            os.makedirs(pk_path, mode=0o775, exist_ok=True)
        sk = context.heaan.SecretKey(context.context, str(sk_path_ / _secretkey_file_name))
        key_generator = context.heaan.KeyGenerator(context.context, sk)
        key_generator.gen_common_keys()
        key_generator.save(str(pk_path_))
