import re
import logging

from Lexicalization.RuleBasedLexic import COMMONSENSE_MAPPING

logger = logging.getLogger(__name__)


class CoreQuisiteBase:
    QUESTIONS = {
        "enabling": [
            'When is this possible',
            # 'What makes this possible',
            # 'When is this True',
        ],
        "disabling": [
            'When is this impossible',
            # 'When is this not true',
            # 'What makes this impossible',
        ],
    }
    COND_TYPE = {s.lower(): d.lower() for s, d in [
        ('/r/Usedfor', 'Both'),
        ('/r/CapableOf', 'Both'),
        ('/r/Causes', 'Both'),
        ('/r/CausesDesire', 'Both'),
        ('/r/Desires', 'Both'),
        # disabling only
        ('/r/IsA', 'Disabling'),
        ('/r/PartOf', 'Disabling'),
        # ('/r/Desires', 'Disabling'),
        ('/r/NotDesires', 'Disabling'),
        # enabling only
        ('/r/RelatedTo', 'Enabling'),
        ('/r/CreatedBy', 'Enabling'),
    ]}
    USEFUL_PREDICATE = [s.lower() for s in [
        '/r/Usedfor',
        '/r/CapableOf',
        '/r/Causes',
        '/r/CausesDesire',
        '/r/Desires',
        '/r/IsA',
        '/r/PartOf',
        '/r/Desires',
        '/r/NotDesires',
        '/r/RelatedTo',
        '/r/CreatedBy',
    ]]
    PREDICATE_LEX = {k.lower(): v.lower() for k, v in COMMONSENSE_MAPPING.items()}

    @staticmethod
    def _get_predicate_base(p_lex: str) -> str:
        p_base = p_lex.lower()
        regx = r"".join([r"\b{}\b|".format(w) for w in ['a', 'as', 'of', 'for', 'not', 'by', 'is']])
        p_base = re.sub(regx, "", p_base)
        return p_base

    def _lexicalize_predicate(self, p: str) -> str:
        clean = p.replace('/r/', '')
        logger.debug(f'clean: {clean}')
        return self.PREDICATE_LEX.get(clean)