/*
 * Decompiled with CFR 0.152.
 */
package ter.core;

import ter.core.AlignmentStringUtils;
import ter.core.Shift;
import ter.util.StringUtils;

public class Alignment {
    public String[] ref;
    public String[] hyp;
    public String[] aftershift;
    public Shift[] allshifts = null;
    public double numEdits = 0.0;
    public double numWords = 0.0;
    public char[] alignment = null;
    public String bestRef = "";
    public int numIns = 0;
    public int numDel = 0;
    public int numSub = 0;
    public int numSft = 0;
    public int numWsf = 0;

    public String toString() {
        int i;
        String s = "Original Ref: " + StringUtils.join(" ", this.ref) + "\nOriginal Hyp: " + StringUtils.join(" ", this.hyp) + "\nHyp After Shift: " + StringUtils.join(" ", this.aftershift);
        if (this.alignment != null) {
            s = s + "\nAlignment: (";
            for (i = 0; i < this.alignment.length; ++i) {
                s = s + this.alignment[i];
            }
            s = s + ")";
        }
        if (this.allshifts == null) {
            s = s + "\nNumShifts: 0";
        } else {
            s = s + "\nNumShifts: " + this.allshifts.length;
            for (i = 0; i < this.allshifts.length; ++i) {
                s = s + "\n  " + this.allshifts[i];
            }
        }
        s = s + "\nScore: " + this.score() + " (" + this.numEdits + "/" + this.numWords + ")";
        return s;
    }

    public String toMoreString() {
        String s = "Best Ref: " + StringUtils.join(" ", this.ref) + "\nOrig Hyp: " + StringUtils.join(" ", this.hyp) + "\n";
        s = s + AlignmentStringUtils.getPraStr(this.hyp, this.ref, this.aftershift, this.alignment, this.allshifts, false);
        s = s + String.format("TER Score: %1$6.2f (%2$5.1f/%3$5.1f)\n", 100.0 * this.score(), this.numEdits, this.numWords);
        s = s + AlignmentStringUtils.formatShiftsString(this.hyp, this.ref, this.allshifts);
        return s;
    }

    public double score() {
        if (this.numWords <= 0.0 && this.numEdits > 0.0) {
            return 1.0;
        }
        if (this.numWords <= 0.0) {
            return 0.0;
        }
        return this.numEdits / this.numWords;
    }

    public void populateScoreDetails() {
        int i;
        this.numSft = 0;
        this.numWsf = 0;
        this.numSub = 0;
        this.numDel = 0;
        this.numIns = 0;
        if (this.allshifts != null) {
            for (i = 0; i < this.allshifts.length; ++i) {
                this.numWsf += this.allshifts[i].size();
            }
            this.numSft = this.allshifts.length;
        }
        if (this.alignment != null) {
            block6: for (i = 0; i < this.alignment.length; ++i) {
                switch (this.alignment[i]) {
                    case 'S': 
                    case 'T': {
                        ++this.numSub;
                        continue block6;
                    }
                    case 'D': {
                        ++this.numDel;
                        continue block6;
                    }
                    case 'I': {
                        ++this.numIns;
                    }
                }
            }
        }
    }
}

