from typing import Iterable, List, Tuple, Dict


def _init():
    global _global_dict
    _global_dict = {}


def set_value(key, value):
    _global_dict[key] = value


def refresh_all_global_var():
    for key in _global_dict.keys():
        if not isinstance(_global_dict[key], Iterable):
            _global_dict[key] = 0
        elif isinstance(_global_dict[key], List) or isinstance(_global_dict[key], Tuple):
            for i in range(len(_global_dict[key])):
                _global_dict[key][i] = 0
        elif isinstance(_global_dict[key], Dict):
            for inner_key in _global_dict[key].keys():
                _global_dict[key][inner_key] = 0
        else:
            raise NotImplementedError



def get_value(key, defValue=None):
    try:
        return _global_dict[key]
    except KeyError:
        return defValue