import os
import sqlalchemy
import scipy
from sklearn import svm
import numpy as np
import matplotlib.pyplot as plt


def clean( l1, l2, inc):
    '''
    This method produces the difference between two predictions.
    During this process, the variables also get mapped into the result space of [0,1]
    This is done because it represents the probability of a mistake.
    It is nessesary since the prediction system has never been limited to this space
    :param l1:first gap prediction
    :param l2:second gap prediction
    :param inc:Booflean if second is increased gap of first
    :return:Difference of the gaps
    '''
    if inc:
        if l1 < 0:
            l1 = 0
        elif l1 > 1:
            l1 = 1
        if l2 < 0:
            l2 = 0
        elif l2 > 1:
            l2 = 1
        x = l1 - l2
        return x
    else:
        if l1 < 0:
            l1 = 0
        elif l1 > 1:
            l1 = 1
        if l2 < 0:
            l2 = 0
        elif l2 > 1:
            l2 = 1
        x = l1 - l2
        return x

def analyseGapSizeTraining():
    engine = sqlalchemy.create_engine('sqlite:///ctest_generator_data.db', echo=True)
    fname = os.environ['DKPRO_HOME'] + '/dictionaries/american-english'

    file = open(fname, "r")
    dictf = file.readlines()

    # print('Length of Convert:',len(convert))
    connection = engine.connect()
    table = connection.execute("SELECT * FROM GapSizeCharUpdate")#Update
    keys = connection.execute("SELECT * FROM GapSizeCharUpdate").keys()
    table = list(table)
    model = svm.SVR()
    Xinc = []
    Yinc = []
    Xdec = []
    Ydec = []
    DeltaK = ['LanguageModelProbabilityOfPrefix', 'MaxStringSimWithCandidate', 'NrOfBigramCandidates',
              'NrOfCandidates', 'NrOfTrigramCandidates', 'NrOfUnigramCandidates',
              'BigramSolutionRank', 'LanguageModelProbabilityOfSolution', 'TrigramSolutionRank',
              'UnigramSolutionRank', 'IsCompoundBreak', 'IsReferentialGap']
    differenceInc = {}
    differenceDec = {}

    for i, r in enumerate(table):
        position_char = int(len(r['gap']) / 2) - 1 + float(r["level"])  # Aktuelle Position

        if float(r["level"]) > 0 and i + 1 < len(table):
            full = position_char == len(r['gap']) - 1  # True if no gap is left

            # if full:continue
            # Abstand von vorigem zu diesem element
            #Y = clean(float(r["gapScore"]), float(table[i + 1]["gapScore"]), True)
            Y = float(r["gapScore"]) - float(table[i + 1]["gapScore"])
            Yinc.append(Y)
            if Y > 0:
                for j in range(10, len(r)):
                    # if table[i + 1][keys[j]] != r[keys[j]]:
                    if keys[j] in DeltaK:
                        if keys[j] not in differenceInc:
                            differenceInc.update({keys[j]: ([Y], [r[keys[j]] - table[i + 1][keys[j]]])})
                        else:
                            differenceInc[keys[j]][0].append(Y)
                            differenceInc[keys[j]][1].append(r[keys[j]] - table[i + 1][keys[j]])

        elif i + 1 < len(table) and float(table[i + 1]["level"]) < 0:
            # abstand von diesem zu naechstem element
            Y = clean(float(table[i + 1]["gapScore"]), float(r["gapScore"]), False)

            for j in range(10, len(r)):
                if keys[j] in DeltaK:

                    if keys[j] not in differenceDec:
                        differenceDec.update({keys[j]: ([Y], [table[i + 1][keys[j]] - r[keys[j]]])})
                    else:
                        w = str(r['gap'])
                        differenceDec[keys[j]][0].append(Y)
                        differenceDec[keys[j]][1].append(table[i + 1][keys[j]] - r[keys[j]])

            Ydec.append(Y)

    for n,k in enumerate(differenceInc.keys()):
        correlation_coefficientI, p_valueI = scipy.stats.pearsonr(differenceInc[k][0],differenceInc[k][1])
        correlation_coefficientD, p_valueD = scipy.stats.pearsonr(differenceDec[k][0], differenceDec[k][1])

        fig, ax = plt.subplots()
        ax.scatter(differenceDec[k][1],differenceDec[k][0],alpha=0.2,label='Decrease Word')
        plt.title(k, fontsize=25)
        ax.scatter(differenceInc[k][1],differenceInc[k][0],alpha=0.2,label='Increase Word')
        ax.legend()

        plt.xlabel('feature value difference', fontsize=18)
        plt.ylabel('difficulty difference', fontsize=18)
        plt.show()
        print(k,'& &', round(correlation_coefficientI,3),'& &',round(correlation_coefficientD,3),'\\\\')

        for el1,el2 in zip(sorted(differenceInc.items(),key=lambda p:p[0]),sorted(differenceDec.items(),key=lambda p:p[0])):
            if el1[0]==el2[0]:
                print(el1[0],'&',el1[1],'&',el2[1],'\\\\')
            else:
                print(el1[0],el2[0])
    connection.close()


def analyseGapSelectionFeatures():
    engine = sqlalchemy.create_engine('sqlite:///ctest_generator_data.db', echo=True)
    connection = engine.connect()
    tableFirst = list(connection.execute("SELECT * FROM GapSelectionBrownNew1_2_20"))
    tableSecond = list(connection.execute("SELECT * FROM GapSelectionBrownNew0_2_20"))
    tableAll = list(connection.execute("SELECT * FROM GapSelectionBrown0_1_40"))
    keys = connection.execute("SELECT * FROM GapSelectionBrown0_1_40").keys()
    print(keys)
    original = []
    for index in range(len(tableFirst)):
        original.append(tableSecond[index])
        original.append(tableFirst[index])

    different = ['LeftTrigramLogProbability', 'NrOfUbySenses', 'NumberOfGapsInCoverSentence', 'NumberOfPrecedingGaps',
                 'NumberOfPrecedingGapsInCoverSentence', 'OccursAsGap', 'RightBigramLogProbability',
                 'TrigramLogProbability', 'LeftBigramLogProbability', 'PhoneticScore', 'PhoneticSimilarity',
                 'posProbability', 'OccursAsText', 'NumberOfChunksPerSentence']
    diff = []
    print(len(different))
    values = {}
    percent = []
    l = 0
    bucket = []
    for el, orig in zip(tableAll, original):
        if l != el['text_id']:
            percent.append(sum(bucket) / len(bucket))
            bucket = [orig['gapScore'] - el['gapScore']]
            l = el['text_id']
        else:
            bucket.append(orig['gapScore'] - el['gapScore'])

        if len(el['test']) == len(orig['test']):
            if el['gap'] == orig['gap']:
                d = orig['gapScore'] - el['gapScore']
                # if d<0.05:continue
                diff.append(d)

            for key in different:
                if key in values:
                    values[key].append(orig[key] - el[key])
                else:
                    values[key] = [orig[key] - el[key]]
        else:
            print("Not the same test length!")

    for n, ky in enumerate(values.keys()):
        fig, ax = plt.subplots()
        ax.scatter(values[ky], diff)
        plt.title(ky, fontsize=20)
        plt.ylim(-.5, .5)
        plt.xlabel('feature value difference', fontsize=18)
        plt.ylabel('difficulty difference', fontsize=18)
        plt.show()

    avg = [sum(percent) / len(percent)]
    print(avg)
    fig, ax = plt.subplots()
    ax.scatter(range(len(percent)), sorted(percent))
    plt.title('Test Prediction Score Difference', fontsize=20)
    ax.plot(range(len(percent)), avg * len(percent), label='Mean', linestyle='--')
    plt.xlabel('Text Index', fontsize=18)
    plt.ylabel('difficulty difference', fontsize=18)
    plt.show()

    fig, ax = plt.subplots()
    ax.scatter(range(len(diff)), sorted(diff))
    plt.title('Prediction Score Difference', fontsize=30)
    ax.plot(range(len(diff)), avg * len(diff), label='Mean', linestyle='--')
    plt.xlabel('Gap Index', fontsize=18)
    plt.ylabel('difficulty difference', fontsize=18)
    plt.show()

    connection.close()

def analyseGapSelection():
    engine = sqlalchemy.create_engine('sqlite:///ctest_generator_data.db', echo=True)
    connection = engine.connect()
    keys = connection.execute("SELECT * FROM GapSelectionB2").keys()
    reuters = list(connection.execute("SELECT * FROM GapSelectionR2"))
    brown = list(connection.execute("SELECT * FROM GapSelectionB2"))
    level = [("very easy",'Class1'), ("easy",'Class2'), ("medium",'Class3'), ("difficult",'Class4')]
    spans = {"very easy": (0, 0.25), "easy": (0.25, 0.5), "medium": (0.5, 0.75), "difficult": (0.75, 1)}
    # Wie groß ist die Schwierigkeitsrange die durch das verfahren manipuliert werden kann?
    distance = []
    biggest = []
    score = 0
    for v, d in zip(reuters[:-3], reuters[3:]):
        if v['level'] == "very easy":
            distance.append(d['average'] - v['average'])

    print(max(distance))

    print(sum(distance) / len(distance))

    for l,title in level:
        data_r = [row['average'] for row in reuters if row['level'] == l]
        print('Reuters:', len(data_r))
        avg_r = [sum(data_r) / len(data_r)]
        # print(avg)
        fig, ax = plt.subplots()
        ax.axhspan(spans[l][0], spans[l][1], facecolor='0.5', alpha=0.5)
        ax.scatter(range(len(data_r)), sorted(data_r))
        plt.title('Reuters ' + title, fontsize=20)
        plt.ylim(0, 1)
        plt.xlabel('Text ID', fontsize=18)
        plt.ylabel('Average Prediction Score for Test', fontsize=18)
        ax.plot(range(len(data_r)), avg_r * len(data_r), label='Mean', linestyle='--')

        plt.show()

    for l,title in level:
        data_b = [row['average'] for row in brown if row['level'] == l]
        print('Brown:', len(data_b))
        avg_b = [sum(data_b) / len(data_b)]
        # print(avg)
        fig, ax = plt.subplots()
        ax.axhspan(spans[l][0], spans[l][1], facecolor='0.5', alpha=0.5)
        ax.scatter(range(len(data_b)), sorted(data_b))
        plt.title('Brown ' + title, fontsize=20)
        plt.ylim(0, 1)
        plt.xlabel('Text ID', fontsize=18)
        plt.ylabel('Average Prediction Score for Test', fontsize=18)
        ax.plot(range(len(data_b)), avg_b * len(data_b), label='Mean', linestyle='--')

        plt.show()


def analyseCorpus():
    engine = sqlalchemy.create_engine('sqlite:///ctest_generator_data.db', echo=True)
    connection = engine.connect()
    Names = ['Gutenberg', 'Reuters', 'Brown']
    times = []
    for table_name in Names:
        gaps = []
        result = []

        table = connection.execute("SELECT * FROM " + table_name.lower())  # +"_old")
        for r in table:
            result.append(r['average'])
            times.append(r['time'])
            for k in table.keys()[7:]:
                gaps.append(r[k])

        plt.scatter(range(len(result)), sorted(result))
        plt.title(table_name + ' C-Test Predictions', fontsize=30)
        plt.ylim(-.6, 1)
        plt.xlabel('Text Index', fontsize=18)
        plt.ylabel('Average Gap Predictions', fontsize=18)
        plt.show()

        plt.scatter(range(len(gaps)), sorted(gaps, key=float))
        plt.title(table_name + ' C-Test Gaps', fontsize=30)
        plt.xlabel('Gap Number', fontsize=18)
        plt.ylabel('Gap Prediction', fontsize=18)
        plt.ylim(-1, 1.4)
        plt.show()

        print(table_name + ' Anzahl:', len(result))
        print(table_name + ' Aerage:', (sum(result) / len(result)))
    print("Average time:", sum(times) / len(times))

    connection.close()

def analyseGreedy():
    engine = sqlalchemy.create_engine('sqlite:///ctest_generator_data.db', echo=True)
    connection = engine.connect()
    Names = ['Reuters', 'Brown']

    for table_name in Names:
        result = []

        table = connection.execute("SELECT * FROM " + table_name.lower())  # +"_old")
        for r in table:
            result.append(r['average'])

        MV = np.zeros((5, 5))
        means = [0.1, 0.3, 0.5, 0.7, 0.9]
        stds = [0.01, 0.02, 0.05, 0.1, 0.2]

        for n, mean in enumerate(means):
            for m, std in enumerate(stds):
                for avg in result:
                    if avg <= mean + std and avg >= mean - std:
                        MV[n][m] += 1

        print('	\multirow{5}{*}{\\rotatebox{90}{Mean}} &', ' & '.join([str(v) for v in stds]), "\\\\")
        for n, mean in enumerate([0.1, 0.3, 0.5, 0.7, 0.9]):
            print('&', str(mean), ' & ', ' & '.join([str(round((1 / (v / len(result))) * 10.278, 2)) for v in MV[n]]),
                  '\\\\')

        '''
        very_easy=[]
        easy=[]
        medium=[]
        difficult=[]
        A=[]
        B1=[]
        B2=[]
        C1=[]
        C2=[]

        for avg in result:
            # Classification
            if avg <= 0.25:
                very_easy.append(avg)
            elif avg <=0.5:
                easy.append(avg)
            elif avg <=0.75:
                medium.append(avg)
            else:
                difficult.append(avg)
            if avg<=0.2:
                A.append(avg)
            elif avg <=0.5:
                B1.append(avg)
            elif avg <=0.65:
                B2.append(avg)
            elif avg <=0.85:
                C1.append(avg)
            else:
                C2.append(avg)

        print('Very Easy: ',(1/((len(very_easy)/len(result))))*10.278)
        print('Easy: ',(1/((len(easy) / len(result))))*10.278)
        print('Medium: ',(1/((len(medium) / len(result))))*10.278)
        if len(difficult)==0:
            print('Difficult: \infty')
        else:
            print('Difficult: ', (1/((len(difficult) / len(result))))* 10.278)

        print('A &',(len(A) / len(result)),'&',(1 / ((len(A) / len(result)))),'&', (1 / ((len(A) / len(result)))) * 10.278)
        print('B1 &', (len(B1) / len(result)), '&', (1 / ((len(B1) / len(result)))), '&',
              (1 / ((len(B1) / len(result)))) * 10.278)
        print('B2 &', (len(B2) / len(result)), '&', (1 / ((len(B2) / len(result)))), '&',
              (1 / ((len(B2) / len(result)))) * 10.278)
        if len(difficult) == 0:
            print('C1& 0/%&$\infty$&$\infty$')
        else:
            print('C1&', (len(C1) / len(result)), '&', (1 / ((len(C1) / len(result)))), '&',
                  (1 / ((len(C1) / len(result)))) * 10.278)

        if len(difficult) == 0:
            print('C2& 0/%&$\infty$&$\infty$')
        else:
            print('C2 &', (len(C2) / len(result)), '&', (1 / ((len(C2) / len(result)))), '&',
                  (1 / ((len(C2) / len(result)))) * 10.278)
            '''

    connection.close()

def analyseGapSize():
    engine = sqlalchemy.create_engine('sqlite:///ctest_generator_data.db', echo=True)
    connection = engine.connect()
    reuters = list(connection.execute("SELECT * FROM GapSizeR "))
    brown = list(connection.execute("SELECT * FROM GapSizeB2"))
    level =  [("very easy",'Class1'), ("easy",'Class2'), ("medium",'Class3'), ("difficult",'Class4')]
    spans = {"very easy": (0, 0.25), "easy": (0.25, 0.5), "medium": (0.5, 0.75), "difficult": (0.75, 1)}
    # Wie groß ist die Schwierigkeitsrange die durch das verfahren manipuliert werden kann?
    distance = []
    biggest = []
    score = 0
    for v, d in zip(brown[:-3], brown[3:]):
        if v['level'] == "very easy":
            distance.append( d['average'] - v['average'])
            if abs(d['average'] - v['average']) > 0.4:
                score = abs(d['average'] - v['average'])
                biggest.append(
                    [v['test'], v['average'], d['average'] - v['average'], d['test'], d['average'], d['text_id']])
    for big in biggest:
        for r in big:
            print(r)


    print('Avg Distance',sum(distance)/len(distance))
    print('Max Distance', max(distance))

    for l, title in level:
        data_r = [row['average'] for row in reuters if row['level']==l]
        print('Reuters:', len(data_r))
        avg_r = [sum(data_r) / len(data_r)]
        # print(avg)
        fig, ax = plt.subplots()
        ax.axhspan(spans[l][0], spans[l][1], facecolor='0.5', alpha=0.5)
        ax.scatter(range(len(data_r)),sorted(data_r) )
        plt.title('Reuters '+title, fontsize=20)
        plt.ylim(0, 1)
        plt.xlabel('Text ID', fontsize=18)
        plt.ylabel('Average Prediction Score for Test', fontsize=18)
        ax.plot(range(len(data_r)), avg_r * len(data_r), label='Mean', linestyle='--')
        fig.savefig('dump/r' + l[0] + 's.png', dpi=fig.dpi)

        plt.show()

    for l, title in level:
        data_b = [row['average'] for row in brown if row['level'] == l]
        print('Brown:',len(data_b))
        avg_b = [sum(data_b) / len(data_b)]
        # print(avg)
        fig, ax = plt.subplots()
        ax.axhspan(spans[l][0], spans[l][1], facecolor='0.5', alpha=0.5)
        ax.scatter(range(len(data_b)), sorted(data_b))
        plt.title('Brown '+title, fontsize=20)
        plt.ylim(0, 1)
        plt.xlabel('Text ID', fontsize=18)
        plt.ylabel('Average Prediction Score for Test', fontsize=18)
        ax.plot(range(len(data_b)), avg_b * len(data_b), label='Mean', linestyle='--')
        fig.savefig('dump/b' + l[0] + 's.png', dpi=fig.dpi)
        plt.show()

#analyseGapSize()
