#ifndef INCLUDED_W2V_
#define INCLUDED_W2V_

#include <string>
#include <stdint.h>
#include <vector>
#include <unordered_map>
#include <utility>
#include "../vocab/vocab.h"

class w2v
{
    bool d_bin;
    
    uint64_t d_numWords;
    uint64_t d_numCands;

    std::vector<std::string> d_resCands;
    std::vector<double> d_resVals;

    /////////////////////////////////// FAST
    Vocab d_vocab;
    std::vector<uint32_t> d_cands;
    std::vector<double> d_vals;

    /////////////////////////////////// SLOW
    char st1[2000];
    char *bestw[200];
    char file_name[2000], st[100][2000];
    float dist, len, bestd[200], vec[2000];
    long long words, size, a, b, c, d, cn, bi[100];
    float *M;
    char *vocab;
    std::unordered_map<std::string, std::pair<std::vector<double>, std::vector<std::string>>> d_cache;

    public:
        w2v();
        w2v(std::string const &path, bool bin);
        ~w2v();

        int load(std::string const &path);
        void loadBin(std::string const &path);
        void loadTxt(std::string const &path);

        void saveBin(std::string const &path);

        bool find(char const *word);
        bool findFast(char const *word);
        bool findSlow(char const *word);
        std::string *getCands(){return &d_resCands[0];};
        double *getVals(){return &d_resVals[0];};
        size_t getNumCands(){return d_numCands;};

        void writeCache(std::string loc = "cache");
        void readCache(std::string loc = "cache");

    private:
        std::string preProcess(std::string word);


};
        
#endif
