#include "w2v.ih"

bool w2v::findFast(char const *word)
{
    uint32_t wordId = d_vocab.getId(word);
    if(wordId == 0)
        return false;
    memcpy(&d_resVals[0], &d_vals[wordId * d_numCands], sizeof(double) * d_numCands);
    for (uint32_t candIdx = 0; candIdx != d_numCands; ++candIdx)
    {
        uint32_t candId = d_cands[(wordId * d_numCands) + candIdx];
        d_resCands[candIdx] = d_vocab.getWord(candId);
    }
    return true;
}
