#include "model.ih"

void Model::writeEval(ostream *out)
{
    (*out) << "RESULTS:\n";
    for (size_t beg = 10; beg != 0; --beg)
        (*out) << beg << '\t' << d_config->recall[beg-1] << '\n';
    (*out) << "notFound: " << d_config->notFound << '\n';
    (*out) << "Total: " << d_config->totalWords << '\n';
    (*out) << "Average candidates: " << double(d_config->totalCands) / d_config->totalWords << '\n';
    (*out) << "Upperbound: " << (double(d_config->totalWords - d_config->notFound) / 
            d_config->totalWords) << '\n';
    (*out) << "Baseline: " << ((d_config->totalWords - d_config->goldTotalNormed) / 
            double(d_config->totalWords)) << '\n';
    size_t cumulat = 0;
    for (size_t beg = 0; beg != 10; ++beg)
    {
        cumulat += d_config->recall[beg];
        (*out) << beg+1 << '\t' <<  (cumulat/double(d_config->totalWords)) << '\n';
    }

    (*out) << "RESULTS:\n";
    double prec = double(d_config->corNorm) / d_config->totalNormed;
    double rec = double(d_config->corNorm) / d_config->goldTotalNormed;
    double f1 = 2 * (prec * rec) / (prec + rec);
    (*out) << "prec: " << prec << '\t' << "rec: " << rec << '\t' 
            << "f1: " << f1 << '\n';
}

