#include "model.ih"

bool Model::readRaw(istream *input)
{
    d_origs.clear();
    string line;
    if(getline((*input), line))
    {
        string word;
        stringstream lineStream(line);
        while (lineStream >> word)
        {
            if (d_config->tokenize)
                for (string token: tokenize(word, ".\"?!&*(){}:;/,~\\"))
                {
                    if (!d_config->caps)
                        transform(token.begin(), token.end(), token.begin(), ::tolower);
                    d_origs.push_back(token);
                }
            else
            {
                if (!d_config->caps)
                    transform(word.begin(), word.end(), word.begin(), ::tolower);
                d_origs.push_back(word);
            }
        }
        return true;
    }
    return false;
}
