#ifndef INCLUDED_CONFIG_
#define INCLUDED_CONFIG_

#include <vector>
#include <string>

struct Config
{
    // paths for feature generation
    std::string w2v;
    bool w2vB;
    std::string twitter;
    bool twitterB;
    std::string wiki;
    bool wikiB;
    std::string knowns;
    bool knownsB;
    std::string dict;
    bool dictB;
    std::string nes;
    bool nesB;
    std::string aspLan;
    std::string aspExtra;
    std::string aspMode;
    std::string parserPath;
    std::string parserArgs;

    // binary args
    bool normAll;
    bool caps;
    bool goldErrDet;
    bool tokenize;
    bool verbose;
    bool parse;
    bool train;

    // misc config options
    size_t numTrain;
    size_t numDev;
    size_t numThreads;
    size_t numCands;
    double weight;
    size_t seed;
    std::string header;

    // classifier options
    std::string cleanedPath;
    std::string regrPath;
    std::string featsPath;
    std::string lookupPath;
    std::string lookupPath2;
    std::string tmpFile;
    size_t numFeats;
    std::vector<bool> featGroups;

    // used as features in Model::gen()
    std::vector<double> idxs;

    // Evaluation
    std::vector<size_t> recall; //initialized in model
    size_t notFound = 0;
    size_t totalNormed = 0;
    size_t goldTotalNormed = 0;
    size_t totalWords = 0;
    size_t totalCands = 0;
    size_t corNorm = 0;

    std::string goldTreebank;

    public:
        Config(){};

    private:

};

#endif
