#include <memory>
#include <iomanip>
#include <cstring>
#include <fstream>
#include <sstream>
#include <unordered_map>

#include "common/token/supertag.h"
#include "include/learning//tree/lca.h"

#include "common/parser/implementations/graph_dp/graphparsing_1ec_n4/graphparsing_1ec_n4_run.h"
#include "common/parser/implementations/graph_dp/graphparsing_1ec_n5/graphparsing_1ec_n5_run.h"

int main(int argc, char * argv[]) {

	std::ios_base::sync_with_stdio(false);
	std::cin.tie(NULL);
	std::cout << std::fixed << std::setprecision(4);

	srand(594902440);
	std::unique_ptr<RunBase> run(nullptr);
	for (int i = 0 ; i < argc ; i++)
		std::cout << argv[i] << ' ';
	std::cout << std::endl;
	if (strcmp(argv[2], "1ec_n4") == 0)
		run.reset(new graphparsing_1ec_n4::Run());
	else if (strcmp(argv[2], "1ec_n5") == 0)
		run.reset(new graphparsing_1ec_n5::Run());

	if (strcmp(argv[1], "goldtest") == 0) {
		run->goldtest(argv[5], argv[4]);
		system("pause");
	}
	else if (strcmp(argv[1],"train+goldtest")==0 ) {

		int iteration = std::atoi(argv[6]);
		std::string raw_feature;
		std::string current_feature;
		std::string next_feature;
		std::cout << "train start" << std::endl;
		current_feature = next_feature = argv[4];
		raw_feature = next_feature;
		next_feature = raw_feature + ".feat";

		for (int i = 0; i < iteration; ++i) {
			std::cout << i + 1 <<std::endl;

			run->train(argv[3], current_feature, next_feature);
			if (strcmp(argv[1], "train+goldtest") == 0)
				run->goldtest(argv[5], next_feature);
			current_feature = next_feature;
			std::cout << next_feature << std::endl;
			//next_feature = raw_feature +'_'+ std::to_string(i + 2) + ".feat";
			system("pause");
		}
	}
	else if (strcmp(argv[1],"train")==0 ) {

		int iteration = std::atoi(argv[5]);
		std::string raw_feature;
		std::string current_feature;
		std::string next_feature;
		std::cout << "train start" << std::endl;
		current_feature = next_feature = argv[4];
		raw_feature = next_feature;
		next_feature = raw_feature + ".feat";

		for (int i = 0; i < iteration; ++i) {
			std::cout << i + 1 <<std::endl;
			run->train(argv[3], current_feature, next_feature);
			current_feature = next_feature;
			std::cout << next_feature << std::endl;
			//next_feature = raw_feature +'_'+ std::to_string(i + 2) + ".feat";
			system("pause");
		}
	}
	else if (strcmp(argv[1], "parse") == 0) {
		std::cout << argv[3] << ' ' << argv[5] << ' ' << argv[4] << std::endl;
		run->parse(argv[3], argv[5], argv[4]);
	}
	system("pause");
}
