/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.ardverk.collection.AbstractPatriciaTrie;
import org.ardverk.collection.KeyAnalyzer;
import org.ardverk.collection.Tries;

public class PatriciaTrie<K, V>
extends AbstractPatriciaTrie<K, V>
implements Serializable {
    private static final long serialVersionUID = -2246014692353432660L;

    public PatriciaTrie() {
    }

    public PatriciaTrie(Map<? extends K, ? extends V> map) {
        super(map);
    }

    public PatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        super(keyAnalyzer);
    }

    public PatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer, Map<? extends K, ? extends V> map) {
        super(keyAnalyzer, map);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keyAnalyzer;
    }

    @Override
    public SortedMap<K, V> prefixMap(K k) {
        int n = this.lengthInBits(k);
        if (n == 0) {
            return this;
        }
        return new PrefixRangeMap(k);
    }

    @Override
    public K firstKey() {
        return this.firstEntry().getKey();
    }

    @Override
    public K lastKey() {
        AbstractPatriciaTrie.TrieEntry<K, V> trieEntry = this.lastEntry();
        if (trieEntry != null) {
            return trieEntry.getKey();
        }
        return null;
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return new RangeEntryMap(null, k);
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return new RangeEntryMap(k, k2);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return new RangeEntryMap(k, null);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> higherEntry(K k) {
        int n = this.lengthInBits(k);
        if (n == 0) {
            if (!this.root.isEmpty()) {
                if (this.size() > 1) {
                    return this.nextEntry(this.root);
                }
                return null;
            }
            return this.firstEntry();
        }
        AbstractPatriciaTrie.TrieEntry trieEntry = this.getNearestEntryForKey(k);
        if (this.compareKeys(k, trieEntry.key)) {
            return this.nextEntry(trieEntry);
        }
        int n2 = this.bitIndex(k, trieEntry.key);
        if (Tries.isValidBitIndex(n2)) {
            AbstractPatriciaTrie.TrieEntry<K, Object> trieEntry2 = new AbstractPatriciaTrie.TrieEntry<K, Object>(k, null, n2);
            this.addEntry(trieEntry2);
            this.incrementSize();
            AbstractPatriciaTrie.TrieEntry<K, Object> trieEntry3 = this.nextEntry(trieEntry2);
            this.removeEntry(trieEntry2);
            this.modCount -= 2;
            return trieEntry3;
        }
        if (Tries.isNullBitKey(n2)) {
            if (!this.root.isEmpty()) {
                return this.firstEntry();
            }
            if (this.size() > 1) {
                return this.nextEntry(this.firstEntry());
            }
            return null;
        }
        if (Tries.isEqualBitKey(n2)) {
            return this.nextEntry(trieEntry);
        }
        throw new IllegalStateException("invalid lookup: " + k);
    }

    AbstractPatriciaTrie.TrieEntry<K, V> ceilingEntry(K k) {
        int n = this.lengthInBits(k);
        if (n == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        AbstractPatriciaTrie.TrieEntry trieEntry = this.getNearestEntryForKey(k);
        if (this.compareKeys(k, trieEntry.key)) {
            return trieEntry;
        }
        int n2 = this.bitIndex(k, trieEntry.key);
        if (Tries.isValidBitIndex(n2)) {
            AbstractPatriciaTrie.TrieEntry<K, Object> trieEntry2 = new AbstractPatriciaTrie.TrieEntry<K, Object>(k, null, n2);
            this.addEntry(trieEntry2);
            this.incrementSize();
            AbstractPatriciaTrie.TrieEntry<K, Object> trieEntry3 = this.nextEntry(trieEntry2);
            this.removeEntry(trieEntry2);
            this.modCount -= 2;
            return trieEntry3;
        }
        if (Tries.isNullBitKey(n2)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        if (Tries.isEqualBitKey(n2)) {
            return trieEntry;
        }
        throw new IllegalStateException("invalid lookup: " + k);
    }

    AbstractPatriciaTrie.TrieEntry<K, V> lowerEntry(K k) {
        int n = this.lengthInBits(k);
        if (n == 0) {
            return null;
        }
        AbstractPatriciaTrie.TrieEntry trieEntry = this.getNearestEntryForKey(k);
        if (this.compareKeys(k, trieEntry.key)) {
            return this.previousEntry(trieEntry);
        }
        int n2 = this.bitIndex(k, trieEntry.key);
        if (Tries.isValidBitIndex(n2)) {
            AbstractPatriciaTrie.TrieEntry<K, Object> trieEntry2 = new AbstractPatriciaTrie.TrieEntry<K, Object>(k, null, n2);
            this.addEntry(trieEntry2);
            this.incrementSize();
            AbstractPatriciaTrie.TrieEntry<K, Object> trieEntry3 = this.previousEntry(trieEntry2);
            this.removeEntry(trieEntry2);
            this.modCount -= 2;
            return trieEntry3;
        }
        if (Tries.isNullBitKey(n2)) {
            return null;
        }
        if (Tries.isEqualBitKey(n2)) {
            return this.previousEntry(trieEntry);
        }
        throw new IllegalStateException("invalid lookup: " + k);
    }

    AbstractPatriciaTrie.TrieEntry<K, V> floorEntry(K k) {
        int n = this.lengthInBits(k);
        if (n == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        AbstractPatriciaTrie.TrieEntry trieEntry = this.getNearestEntryForKey(k);
        if (this.compareKeys(k, trieEntry.key)) {
            return trieEntry;
        }
        int n2 = this.bitIndex(k, trieEntry.key);
        if (Tries.isValidBitIndex(n2)) {
            AbstractPatriciaTrie.TrieEntry<K, Object> trieEntry2 = new AbstractPatriciaTrie.TrieEntry<K, Object>(k, null, n2);
            this.addEntry(trieEntry2);
            this.incrementSize();
            AbstractPatriciaTrie.TrieEntry<K, Object> trieEntry3 = this.previousEntry(trieEntry2);
            this.removeEntry(trieEntry2);
            this.modCount -= 2;
            return trieEntry3;
        }
        if (Tries.isNullBitKey(n2)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        if (Tries.isEqualBitKey(n2)) {
            return trieEntry;
        }
        throw new IllegalStateException("invalid lookup: " + k);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> subtree(K k) {
        AbstractPatriciaTrie.TrieEntry trieEntry;
        int n = this.lengthInBits(k);
        AbstractPatriciaTrie.TrieEntry trieEntry2 = this.root.left;
        AbstractPatriciaTrie.TrieEntry trieEntry3 = this.root;
        while (trieEntry2.bitIndex > trieEntry3.bitIndex && n >= trieEntry2.bitIndex) {
            trieEntry3 = trieEntry2;
            if (!this.isBitSet(k, trieEntry2.bitIndex)) {
                trieEntry2 = trieEntry2.left;
                continue;
            }
            trieEntry2 = trieEntry2.right;
        }
        AbstractPatriciaTrie.TrieEntry trieEntry4 = trieEntry = trieEntry2.isEmpty() ? trieEntry3 : trieEntry2;
        if (trieEntry.isEmpty()) {
            return null;
        }
        if (trieEntry == this.root && this.lengthInBits(trieEntry.getKey()) < n) {
            return null;
        }
        if (this.isBitSet(k, n) != this.isBitSet(trieEntry.key, n)) {
            return null;
        }
        int n2 = this.bitIndex(k, trieEntry.key);
        if (n2 >= 0 && n2 < n) {
            return null;
        }
        return trieEntry;
    }

    @Override
    private AbstractPatriciaTrie.TrieEntry<K, V> lastEntry() {
        return this.followRight(this.root.left);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> followRight(AbstractPatriciaTrie.TrieEntry<K, V> trieEntry) {
        if (trieEntry.right == null) {
            return null;
        }
        while (trieEntry.right.bitIndex > trieEntry.bitIndex) {
            trieEntry = trieEntry.right;
        }
        return trieEntry.right;
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> previousEntry(AbstractPatriciaTrie.TrieEntry<K, V> trieEntry) {
        if (trieEntry.predecessor == null) {
            throw new IllegalArgumentException("must have come from somewhere!");
        }
        if (trieEntry.predecessor.right == trieEntry) {
            if (PatriciaTrie.isValidUplink(trieEntry.predecessor.left, trieEntry.predecessor)) {
                return trieEntry.predecessor.left;
            }
            return this.followRight(trieEntry.predecessor.left);
        }
        AbstractPatriciaTrie.TrieEntry trieEntry2 = trieEntry.predecessor;
        while (trieEntry2.parent != null && trieEntry2 == trieEntry2.parent.left) {
            trieEntry2 = trieEntry2.parent;
        }
        if (trieEntry2.parent == null) {
            return null;
        }
        if (PatriciaTrie.isValidUplink(trieEntry2.parent.left, trieEntry2.parent)) {
            if (trieEntry2.parent.left == this.root) {
                if (this.root.isEmpty()) {
                    return null;
                }
                return this.root;
            }
            return trieEntry2.parent.left;
        }
        return this.followRight(trieEntry2.parent.left);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> nextEntryInSubtree(AbstractPatriciaTrie.TrieEntry<K, V> trieEntry, AbstractPatriciaTrie.TrieEntry<K, V> trieEntry2) {
        if (trieEntry == null) {
            return this.firstEntry();
        }
        return this.nextEntryImpl(trieEntry.predecessor, trieEntry, trieEntry2);
    }

    private boolean isPrefix(K k, K k2) {
        return this.keyAnalyzer.isPrefix(k, k2);
    }

    private final class PrefixRangeEntrySet
    extends RangeEntrySet {
        private final PrefixRangeMap delegate;
        private AbstractPatriciaTrie.TrieEntry<K, V> prefixStart;
        private int expectedModCount;

        public PrefixRangeEntrySet(PrefixRangeMap prefixRangeMap) {
            super(prefixRangeMap);
            this.expectedModCount = -1;
            this.delegate = prefixRangeMap;
        }

        @Override
        public int size() {
            return this.delegate.fixup();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            if (PatriciaTrie.this.modCount != this.expectedModCount) {
                this.prefixStart = PatriciaTrie.this.subtree(this.delegate.prefix);
                this.expectedModCount = PatriciaTrie.this.modCount;
            }
            if (this.prefixStart == null) {
                Set set = Collections.emptySet();
                return set.iterator();
            }
            if (PatriciaTrie.this.lengthInBits(this.delegate.prefix) >= this.prefixStart.bitIndex) {
                return new SingletonIterator(this.prefixStart);
            }
            return new EntryIterator(this.prefixStart, this.delegate.prefix);
        }

        private final class EntryIterator
        extends AbstractPatriciaTrie.TrieIterator<Map.Entry<K, V>> {
            protected final K prefix;
            protected boolean lastOne;
            protected AbstractPatriciaTrie.TrieEntry<K, V> subtree;

            EntryIterator(AbstractPatriciaTrie.TrieEntry<K, V> trieEntry, K k) {
                this.subtree = trieEntry;
                this.next = PatriciaTrie.this.followLeft(trieEntry);
                this.prefix = k;
            }

            @Override
            public Map.Entry<K, V> next() {
                AbstractPatriciaTrie.TrieEntry trieEntry = this.nextEntry();
                if (this.lastOne) {
                    this.next = null;
                }
                return trieEntry;
            }

            @Override
            protected AbstractPatriciaTrie.TrieEntry<K, V> findNext(AbstractPatriciaTrie.TrieEntry<K, V> trieEntry) {
                return PatriciaTrie.this.nextEntryInSubtree(trieEntry, this.subtree);
            }

            @Override
            public void remove() {
                boolean bl = false;
                int n = this.subtree.bitIndex;
                if (this.current == this.subtree) {
                    bl = true;
                }
                super.remove();
                if (n != this.subtree.bitIndex || bl) {
                    this.subtree = PatriciaTrie.this.subtree(this.prefix);
                }
                if (PatriciaTrie.this.lengthInBits(this.prefix) >= this.subtree.bitIndex) {
                    this.lastOne = true;
                }
            }
        }

        private final class SingletonIterator
        implements Iterator<Map.Entry<K, V>> {
            private final AbstractPatriciaTrie.TrieEntry<K, V> entry;
            private int hit = 0;

            public SingletonIterator(AbstractPatriciaTrie.TrieEntry<K, V> trieEntry) {
                this.entry = trieEntry;
            }

            @Override
            public boolean hasNext() {
                return this.hit == 0;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.hit != 0) {
                    throw new NoSuchElementException();
                }
                ++this.hit;
                return this.entry;
            }

            @Override
            public void remove() {
                if (this.hit != 1) {
                    throw new IllegalStateException();
                }
                ++this.hit;
                PatriciaTrie.this.removeEntry(this.entry);
            }
        }
    }

    private class PrefixRangeMap
    extends RangeMap {
        private final K prefix;
        private K fromKey;
        private K toKey;
        private int expectedModCount;
        private int size;

        private PrefixRangeMap(K k) {
            this.fromKey = null;
            this.toKey = null;
            this.expectedModCount = -1;
            this.size = -1;
            this.prefix = k;
        }

        private int fixup() {
            if (this.size == -1 || PatriciaTrie.this.modCount != this.expectedModCount) {
                Iterator iterator = this.entrySet().iterator();
                this.size = 0;
                Map.Entry entry = null;
                if (iterator.hasNext()) {
                    entry = iterator.next();
                    this.size = 1;
                }
                Object v0 = (this.fromKey = entry == null ? null : entry.getKey());
                if (this.fromKey != null) {
                    AbstractPatriciaTrie.TrieEntry trieEntry = PatriciaTrie.this.previousEntry((AbstractPatriciaTrie.TrieEntry)entry);
                    this.fromKey = trieEntry == null ? null : trieEntry.getKey();
                }
                this.toKey = this.fromKey;
                while (iterator.hasNext()) {
                    ++this.size;
                    entry = iterator.next();
                }
                this.toKey = entry == null ? null : entry.getKey();
                Object v1 = this.toKey;
                if (this.toKey != null) {
                    this.toKey = (entry = PatriciaTrie.this.nextEntry((AbstractPatriciaTrie.TrieEntry)entry)) == null ? null : entry.getKey();
                }
                this.expectedModCount = PatriciaTrie.this.modCount;
            }
            return this.size;
        }

        @Override
        public K firstKey() {
            Object k;
            this.fixup();
            AbstractPatriciaTrie.TrieEntry trieEntry = null;
            trieEntry = this.fromKey == null ? PatriciaTrie.this.firstEntry() : PatriciaTrie.this.higherEntry(this.fromKey);
            Object k2 = k = trieEntry != null ? (Object)trieEntry.getKey() : null;
            if (trieEntry == null || !PatriciaTrie.this.isPrefix(k, this.prefix)) {
                throw new NoSuchElementException();
            }
            return k;
        }

        @Override
        public K lastKey() {
            Object k;
            this.fixup();
            AbstractPatriciaTrie.TrieEntry trieEntry = null;
            trieEntry = this.toKey == null ? PatriciaTrie.this.lastEntry() : PatriciaTrie.this.lowerEntry(this.toKey);
            Object k2 = k = trieEntry != null ? (Object)trieEntry.getKey() : null;
            if (trieEntry == null || !PatriciaTrie.this.isPrefix(k, this.prefix)) {
                throw new NoSuchElementException();
            }
            return k;
        }

        @Override
        protected boolean inRange(K k) {
            return PatriciaTrie.this.isPrefix(k, this.prefix);
        }

        @Override
        protected boolean inRange2(K k) {
            return this.inRange(k);
        }

        @Override
        protected boolean inFromRange(K k, boolean bl) {
            return PatriciaTrie.this.isPrefix(k, this.prefix);
        }

        @Override
        protected boolean inToRange(K k, boolean bl) {
            return PatriciaTrie.this.isPrefix(k, this.prefix);
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            return new PrefixRangeEntrySet(this);
        }

        @Override
        public K getFromKey() {
            return this.fromKey;
        }

        @Override
        public K getToKey() {
            return this.toKey;
        }

        @Override
        public boolean isFromInclusive() {
            return false;
        }

        @Override
        public boolean isToInclusive() {
            return false;
        }

        @Override
        protected SortedMap<K, V> createRangeMap(K k, boolean bl, K k2, boolean bl2) {
            return new RangeEntryMap(k, bl, k2, bl2);
        }
    }

    private class RangeEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final RangeMap delegate;
        private int size = -1;
        private int expectedModCount = -1;

        public RangeEntrySet(RangeMap rangeMap) {
            if (rangeMap == null) {
                throw new NullPointerException("delegate");
            }
            this.delegate = rangeMap;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Object k = this.delegate.getFromKey();
            Object k2 = this.delegate.getToKey();
            AbstractPatriciaTrie.TrieEntry trieEntry = null;
            trieEntry = k == null ? PatriciaTrie.this.firstEntry() : PatriciaTrie.this.ceilingEntry(k);
            AbstractPatriciaTrie.TrieEntry trieEntry2 = null;
            if (k2 != null) {
                trieEntry2 = PatriciaTrie.this.ceilingEntry(k2);
            }
            return new EntryIterator(trieEntry, trieEntry2);
        }

        @Override
        public int size() {
            if (this.size == -1 || this.expectedModCount != PatriciaTrie.this.modCount) {
                this.size = 0;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ++this.size;
                    iterator.next();
                }
                this.expectedModCount = PatriciaTrie.this.modCount;
            }
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            if (!this.delegate.inRange(k)) {
                return false;
            }
            AbstractPatriciaTrie.TrieEntry trieEntry = PatriciaTrie.this.getEntry(k);
            return trieEntry != null && Tries.areEqual(trieEntry.getValue(), entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            if (!this.delegate.inRange(k)) {
                return false;
            }
            AbstractPatriciaTrie.TrieEntry trieEntry = PatriciaTrie.this.getEntry(k);
            if (trieEntry != null && Tries.areEqual(trieEntry.getValue(), entry.getValue())) {
                PatriciaTrie.this.removeEntry(trieEntry);
                return true;
            }
            return false;
        }

        private final class EntryIterator
        extends AbstractPatriciaTrie.TrieIterator<Map.Entry<K, V>> {
            private final K excludedKey;

            private EntryIterator(AbstractPatriciaTrie.TrieEntry<K, V> trieEntry, AbstractPatriciaTrie.TrieEntry<K, V> trieEntry2) {
                super(trieEntry);
                this.excludedKey = trieEntry2 != null ? trieEntry2.getKey() : null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null && !Tries.areEqual(this.next.key, this.excludedKey);
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.next == null || Tries.areEqual(this.next.key, this.excludedKey)) {
                    throw new NoSuchElementException();
                }
                return this.nextEntry();
            }
        }
    }

    private class RangeEntryMap
    extends RangeMap {
        protected final K fromKey;
        protected final K toKey;
        protected final boolean fromInclusive;
        protected final boolean toInclusive;

        protected RangeEntryMap(K k, K k2) {
            this(k, true, k2, false);
        }

        protected RangeEntryMap(K k, boolean bl, K k2, boolean bl2) {
            if (k == null && k2 == null) {
                throw new IllegalArgumentException("must have a from or to!");
            }
            if (k != null && k2 != null && PatriciaTrie.this.keyAnalyzer.compare(k, k2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = k;
            this.fromInclusive = bl;
            this.toKey = k2;
            this.toInclusive = bl2;
        }

        @Override
        public K firstKey() {
            Object k;
            AbstractPatriciaTrie.TrieEntry trieEntry = null;
            trieEntry = this.fromKey == null ? PatriciaTrie.this.firstEntry() : (this.fromInclusive ? PatriciaTrie.this.ceilingEntry(this.fromKey) : PatriciaTrie.this.higherEntry(this.fromKey));
            Object k2 = k = trieEntry != null ? (Object)trieEntry.getKey() : null;
            if (trieEntry == null || this.toKey != null && !this.inToRange(k, false)) {
                throw new NoSuchElementException();
            }
            return k;
        }

        @Override
        public K lastKey() {
            Object k;
            AbstractPatriciaTrie.TrieEntry trieEntry = this.toKey == null ? PatriciaTrie.this.lastEntry() : (this.toInclusive ? PatriciaTrie.this.floorEntry(this.toKey) : PatriciaTrie.this.lowerEntry(this.toKey));
            Object k2 = k = trieEntry != null ? (Object)trieEntry.getKey() : null;
            if (trieEntry == null || this.fromKey != null && !this.inFromRange(k, false)) {
                throw new NoSuchElementException();
            }
            return k;
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            return new RangeEntrySet(this);
        }

        @Override
        public K getFromKey() {
            return this.fromKey;
        }

        @Override
        public K getToKey() {
            return this.toKey;
        }

        @Override
        public boolean isFromInclusive() {
            return this.fromInclusive;
        }

        @Override
        public boolean isToInclusive() {
            return this.toInclusive;
        }

        @Override
        protected SortedMap<K, V> createRangeMap(K k, boolean bl, K k2, boolean bl2) {
            return new RangeEntryMap(k, bl, k2, bl2);
        }
    }

    private abstract class RangeMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V> {
        private volatile transient Set<Map.Entry<K, V>> entrySet;

        private RangeMap() {
        }

        protected abstract Set<Map.Entry<K, V>> createEntrySet();

        protected abstract K getFromKey();

        protected abstract boolean isFromInclusive();

        protected abstract K getToKey();

        protected abstract boolean isToInclusive();

        @Override
        public Comparator<? super K> comparator() {
            return PatriciaTrie.this.comparator();
        }

        @Override
        public boolean containsKey(Object object) {
            if (!this.inRange(Tries.cast(object))) {
                return false;
            }
            return PatriciaTrie.this.containsKey(object);
        }

        @Override
        public V remove(Object object) {
            if (!this.inRange(Tries.cast(object))) {
                return null;
            }
            return PatriciaTrie.this.remove(object);
        }

        @Override
        public V get(Object object) {
            if (!this.inRange(Tries.cast(object))) {
                return null;
            }
            return PatriciaTrie.this.get(object);
        }

        @Override
        public V put(K k, V v) {
            if (!this.inRange(k)) {
                throw new IllegalArgumentException("Key is out of range: " + k);
            }
            return PatriciaTrie.this.put(k, v);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = this.createEntrySet();
            }
            return this.entrySet;
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("FromKey is out of range: " + k);
            }
            if (!this.inRange2(k2)) {
                throw new IllegalArgumentException("ToKey is out of range: " + k2);
            }
            return this.createRangeMap(k, this.isFromInclusive(), k2, this.isToInclusive());
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("ToKey is out of range: " + k);
            }
            return this.createRangeMap(this.getFromKey(), this.isFromInclusive(), k, this.isToInclusive());
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("FromKey is out of range: " + k);
            }
            return this.createRangeMap(k, this.isFromInclusive(), this.getToKey(), this.isToInclusive());
        }

        protected boolean inRange(K k) {
            Object k2 = this.getFromKey();
            Object k3 = this.getToKey();
            return !(k2 != null && !this.inFromRange(k, false) || k3 != null && !this.inToRange(k, false));
        }

        protected boolean inRange2(K k) {
            Object k2 = this.getFromKey();
            Object k3 = this.getToKey();
            return !(k2 != null && !this.inFromRange(k, false) || k3 != null && !this.inToRange(k, true));
        }

        protected boolean inFromRange(K k, boolean bl) {
            Object k2 = this.getFromKey();
            boolean bl2 = this.isFromInclusive();
            int n = PatriciaTrie.this.keyAnalyzer.compare(k, k2);
            if (bl2 || bl) {
                return n >= 0;
            }
            return n > 0;
        }

        protected boolean inToRange(K k, boolean bl) {
            Object k2 = this.getToKey();
            boolean bl2 = this.isToInclusive();
            int n = PatriciaTrie.this.keyAnalyzer.compare(k, k2);
            if (bl2 || bl) {
                return n <= 0;
            }
            return n < 0;
        }

        protected abstract SortedMap<K, V> createRangeMap(K var1, boolean var2, K var3, boolean var4);
    }
}

