/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.NumUtils;
import fig.basic.Utils;
import fig.record.ArgsParser;
import fig.record.SubsetHint;
import fig.record.SubsetOracle;
import fig.record.VarBindingList;
import java.util.List;

public class PeriodicSubsetHint
implements SubsetHint {
    private ArgsParser parser;

    public PeriodicSubsetHint(List<String> args, VarBindingList bindings) {
        this.parser = new ArgsParser('?', args);
        this.parser.setNames("start", "end", "stepcount").parse(bindings);
    }

    private boolean indexRequiresTotalCount(String s) {
        return s.endsWith("f") || Utils.parseIntEasy(s, 0) < 0;
    }

    @Override
    public boolean needTotalCount() {
        return this.indexRequiresTotalCount(this.parser.get("start", "")) || this.indexRequiresTotalCount(this.parser.get("end", "")) || !this.parser.get("stepcount", "").equals("") && !this.parser.get("stepcount", "").startsWith("+");
    }

    @Override
    public SubsetOracle getOracle(int n) {
        if (!this.needTotalCount()) {
            return new PeriodicOracle(Integer.MAX_VALUE);
        }
        return new PeriodicOracle(n);
    }

    private class PeriodicOracle
    implements SubsetOracle {
        private int start;
        private int end;
        private int step;
        private int count;

        public PeriodicOracle(int n) {
            this.start = PeriodicSubsetHint.this.parser.get("start", "").endsWith("f") ? (int)(PeriodicSubsetHint.this.parser.getDouble("start", 0.0) * (double)n) : PeriodicSubsetHint.this.parser.getInt("start", 0);
            this.end = PeriodicSubsetHint.this.parser.get("end", "").endsWith("f") ? (int)(PeriodicSubsetHint.this.parser.getDouble("end", 1.0) * (double)n) : PeriodicSubsetHint.this.parser.getInt("end", n);
            this.step = 1;
            this.count = n;
            if (PeriodicSubsetHint.this.parser.get("stepcount", "").startsWith("+")) {
                this.count = -1;
                this.step = Utils.parseIntEasy(PeriodicSubsetHint.this.parser.get("stepcount", "").substring(1), -1);
            } else {
                this.count = PeriodicSubsetHint.this.parser.getInt("stepcount", -1);
                this.step = -1;
            }
            if (this.start < 0) {
                this.start += n;
            }
            if (this.end <= 0) {
                this.end += n;
            }
            this.start = NumUtils.bound(this.start, 0, n);
            this.end = NumUtils.bound(this.end, 0, n);
            if (this.step != -1) {
                this.count = Math.max((this.end - this.start) / this.step, 1);
            } else if (this.count != -1) {
                this.step = Math.max((this.end - this.start) / this.count, 1);
            } else {
                this.count = this.end - this.start;
                this.step = 1;
            }
        }

        @Override
        public int getLowerBound() {
            return this.start;
        }

        @Override
        public int getUpperBound() {
            return this.end;
        }

        @Override
        public boolean inSubset(int i) {
            return i >= this.start && i < this.end && (i - this.start) % this.step == 0 && (i - this.start) / this.step < this.count;
        }
    }
}

