###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#####################################################################
# smooth-srl.rb 
# This script smooth the srl models to the gf so as to increase the 
# success on parsing. 
#
# The first (optional) flag can be -m or -ne
# -m flag will deal with ARG0,...,ARG5, not ARG1-TO, ARG2-THROUGH, etc. 
# -ne flag will futher deal with only ARG0,...,ARG5,ARGM, not ARGM-TMP, ARGM-ADV, etc. 
#
# The required params are: 
# gf-model-file percent-of-gf srl-model-file percent-of-srl
#
# Example:
# ruby scripts/smooth-srl.rb -m genmodel/gf-t2m.wsjpu.model .1 genmodel/srl-t2m.wsjpu.model .9
#
# Sum of percentile should be 1 but it required 2 params to be clear
# Output is to stdout
#
# Author: Luan Nguyen	 
#
######################################################################

require "scripts/umnlp.rb"

$error = false

allLabelsFile = "genmodel/srl-all-labels"

if (ARGV[0] == "-m") 
  allLabelsFile += ".no.main.arg.ext"
  ARGV.shift
elsif (ARGV[0] == "-ne")
  allLabelsFile += ".no.arg.ext"
  ARGV.shift
end

gfFile = ARGV[0]
gfPercent = ARGV[1]
srlFile = ARGV[2]
srlPercent = ARGV[3]

# read the appropriate srl-all-labels file into an array
f = File.open(allLabelsFile) or die "Unable to open file #{allLabelsFile}"
allLabels=[]  # start with an empty array
f.each_line {|line|
  if (line =~ /^#/ || /\S/ !~ line); next; end
  allLabels.push line.strip
}

gf = File.open(gfFile) or die "Unable to open gf file #{gfFile}"
gf.each_line {|line|
  if (line =~ /^G[e|tm|tp|tq]|^Fr/)
    colonSplit = line.split(":")
    equalSplit = colonSplit[1].split("= ")
    prob = "%.8f" % (equalSplit[1].to_f * gfPercent.to_f)
    allLabels.each do |label|
      print colonSplit[0] + label + " :" + equalSplit[0] + "= " + prob + "\n" 
    end 
  elsif (line =~ /^Pc /) #borrow Pc but change to the older Pg model
    #print line.sub(/^Pc/, 'Pg')
    print line
  elsif (line =~ /^W/ || line =~ /^Pw/) #borrow W and Pw as is
    print line
  end
}

srl = File.open(srlFile) or die "Unable to open srl file #{srlFile}"
srl.each_line {|line|
  if (line =~ /^G[e|tm|tp|tq]|^Fr/)
    equalSplit = line.split("= ")
    prob = "%.8f" % (equalSplit[1].to_f * srlPercent.to_f)
    print equalSplit[0] + "= " + prob + "\n" 
  elsif (line !~ /^Pg/ && line !~ /^W/ && line !~ /^Pw/)
    print line
  end
}

