################################################################################
#
#  User-specific parameter files (created by default with default values)
#
#  These parameter files differ from user to user, and should not be checked in.
#  This script just establishes 'official' default values for these parameters.
#
################################################################################

#### location of treebank
include user-ace-location.txt
user-ace-location.txt:
	echo 'USER_ACE_TRAIN_LOCATION = /Volumes/corpora/original/english/ace_phase2/data/ace2_train/' > $@
	echo 'USER_ACE_DEVETEST_LOCATION = /Volumes/corpora/original/english/ace_phase2/data/ace2_devtest/bnews' > $@
	@echo ''
	@echo 'ATTENTION: I had to create "user-ace-location.txt" for you, which may be wrong'
	@echo 'edit it to point at your treebank repository and re-run make to continue!'
	@echo ''


################################################################################
#
#  Corpus pre-processing
#
################################################################################

#%.sgm:


#genmodel/aceTRAIN: $(USER_ACE_LOCATION)
#	cat $*/*.sgm |

%.tagged: ../ModelFileFactory/aceProcessor/TaggingAce02.class $(USER_ACE_TRAIN_LOCATION)/%.sgm
	cat $(word 2,$^).sgm | java $(subst /,.,${<:.class=}) > $@


#not sure how I should write the make file. In fact, for BuildOpPosmodel.java, the input arguments are
#/home/dingcheng/Documents/OSU_corpora/ace_phase2/data/ace2_train/bnews_tagged 
#/home/dingcheng/Documents/OSU_corpora/ace_phase2/data/ace2_train/bnews 
#/home/dingcheng/Documents/OSU_corpora/ace_phase2/data/ace2_train/bnews_tagged_posmodel
# the output is
#/home/dingcheng/Documents/OSU_corpora/ace_phase2/data/ace2_train/bnews_tagged_posmodel/bnews.posmodel
#/home/dingcheng/Documents/OSU_corpora/ace_phase2/data/ace2_train/bnews_tagged_posmodel/bnews.posratio
#/home/dingcheng/Documents/OSU_corpora/ace_phase2/data/ace2_train/bnews_tagged_posmodel/bnews.poWordsmodel
#/home/dingcheng/Documents/OSU_corpora/ace_phase2/data/ace2_train/bnews_tagged_posmodel/bnews.tally
#others are similar

%.posmodel,%.posratio,%.posWordmodel,%.tally: ../ModelFileFactory/aceProcessor/BuildOpPosmodel.class $(USER_ACE_TRAIN_LOCATION)/%_tagged $(USER_ACE_LOCATION)/% $(USER_ACE_LOCATION)/%_tagged_posmodel

%.nemodel,%.neratio,%.neWordmodel,%.opmodel:  ../ModelFileFactory/aceProcessor/ProcessACETrainJdom.class  $(USER_ACE_TRAIN_LOCATION)/%

%.indmodel, %.genmodel, %.nummodel: ../ModelFileFactory/aceProcessor/BuildIgnModel.class  $(USER_ACE_TRAIN_LOCATION)/%

%.wordmodel:  ../ModelFileFactory/aceProcessor/WordModelBuilder.class  $(USER_ACE_TRAIN_LOCATION)/% $(USER_ACE_TRAIN_LOCATION)/%_models
	cat $(word 2,$^).sgm | java $(subst /,.,${<:.class=}) > $@

%.entity, %.texts:  ../ModelFileFactory/aceProcessor/ProcessACEDevJdom.class  $(USER_ACE_DEVETEST_LOCATION)/%.sgm $(USER_ACE_DEVETEST_LOCATION)/%sgm.tmx.rdc.xml
	cat $(word 2,$^).sgm $(word 2,$^).sgm.tmx.rdc.xml|java $(subst /,.,${<:.class=}) > $@

genmodel/POS.%.model:  genmodel/pw.%.tally  bin/postrainer  scripts/relfreq.pl
	cat  genmodel/pw.$*.tally | sed 's/:[^ ][^ ]*//;s/^Pw *\([^ ]*\) *: *\([^ ]*\)/PwDT \1 : \2/' | bin/postrainer | grep -v "WARNING: distribution

%.train: scripts/relfreq.pl cat $(word 2, $^)| > $@

