/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import util.Pair;

public class AllOrderedStringExactSubsequences {
    public static final int maxComb = 1000;
    Cell[][] cellMatrix;
    String[] a1;
    String[] a2;
    int xMax;
    int yMax;
    int xLength;
    int yLength;
    int xRegionStart;
    int xRegionEnd;
    int totalMatched;
    boolean hasOneSolution;
    static char firstChar = (char)65;
    static Random random = new Random();

    public AllOrderedStringExactSubsequences(String[] a1, String[] a2) {
        if (this.xLength < this.yLength) {
            return;
        }
        this.a1 = a1;
        this.a2 = a2;
        this.xLength = a1.length;
        this.yLength = a2.length;
        this.xMax = this.xLength - 1;
        this.yMax = this.yLength - 1;
        this.initMatrix();
    }

    private void initMatrix() {
        int y;
        this.cellMatrix = new Cell[this.xLength][this.yLength];
        boolean foundFirst = false;
        int x = 0;
        while (x < this.xLength) {
            boolean match = AllOrderedStringExactSubsequences.equal(this.a1[x], this.a2[0]);
            if (!foundFirst && match) {
                foundFirst = true;
                this.xRegionStart = x;
            }
            this.cellMatrix[x][0] = new Cell(x, 0, match);
            ++x;
        }
        if (!foundFirst) {
            this.hasOneSolution = false;
            return;
        }
        boolean foundLast = false;
        int x2 = this.xMax;
        while (x2 >= 0) {
            boolean match = AllOrderedStringExactSubsequences.equal(this.a1[x2], this.a2[this.yMax]);
            if (!foundLast && match) {
                foundLast = true;
                this.xRegionEnd = x2;
            }
            this.cellMatrix[x2][this.yMax] = new Cell(x2, this.yMax, match);
            --x2;
        }
        if (!foundLast) {
            this.hasOneSolution = false;
            return;
        }
        x2 = this.xRegionStart;
        while (x2 <= this.xRegionEnd) {
            y = 1;
            while (y < this.yMax) {
                boolean match = AllOrderedStringExactSubsequences.equal(this.a1[x2], this.a2[y]);
                this.cellMatrix[x2][y] = new Cell(x2, y, match);
                ++y;
            }
            ++x2;
        }
        x2 = 0;
        while (x2 < this.xRegionStart) {
            y = 1;
            while (y < this.yMax) {
                this.cellMatrix[x2][y] = new Cell(x2, y, false);
                ++y;
            }
            ++x2;
        }
        x2 = this.xRegionEnd + 1;
        while (x2 < this.xLength) {
            y = 1;
            while (y < this.yMax) {
                this.cellMatrix[x2][y] = new Cell(x2, y, false);
                ++y;
            }
            ++x2;
        }
        if (!this.hasOneSolution()) {
            return;
        }
        x2 = 0;
        while (x2 < this.xLength) {
            Cell c = this.cellMatrix[x2][0];
            if (c.match) {
                c.reachable = true;
                ++x2;
                while (x2 < this.xLength) {
                    c = this.cellMatrix[x2][0];
                    c.setLeftReachable();
                    ++x2;
                }
            }
            ++x2;
        }
        int y2 = 1;
        while (y2 < this.yLength) {
            int x3 = 1;
            while (x3 < this.xLength) {
                Cell c = this.cellMatrix[x3][y2];
                Cell leftCell = this.cellMatrix[x3 - 1][y2];
                if (leftCell.reachable) {
                    c.setLeftReachable();
                }
                if (c.match) {
                    Cell diagonalCell = this.cellMatrix[x3 - 1][y2 - 1];
                    if (diagonalCell.reachable) {
                        c.setDiagonalReachable();
                    }
                }
                ++x3;
            }
            ++y2;
        }
    }

    public boolean hasOneSolution() {
        if (this.totalMatched < this.yLength) {
            this.hasOneSolution = false;
            return false;
        }
        int currentXIndex = 0;
        int y = 0;
        while (y < this.yLength) {
            boolean found = false;
            while (currentXIndex < this.xLength) {
                if (this.cellMatrix[currentXIndex][y].match) {
                    ++currentXIndex;
                    found = true;
                    break;
                }
                ++currentXIndex;
            }
            if (!found) {
                this.hasOneSolution = false;
                return false;
            }
            ++y;
        }
        this.hasOneSolution = true;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<ArrayList<Pair<String>>> getOneSolution() {
        if (!this.hasOneSolution) {
            return null;
        }
        System.out.println("One solution!");
        result = new ArrayList<ArrayList<Pair<String>>>();
        onlySolution = new ArrayList<Pair<String>>();
        currentXIndex = 0;
        y = 0;
        ** GOTO lbl19
        {
            block3: {
                if (!this.cellMatrix[currentXIndex][y].match) break block3;
                onlySolution.add(new Pair<String>(this.a1[currentXIndex], this.a2[y]));
                ++currentXIndex;
                ** GOTO lbl18
            }
            ++currentXIndex;
            do {
                if (currentXIndex < this.xLength) continue block0;
lbl18:
                // 2 sources

                ++y;
lbl19:
                // 2 sources

            } while (y < this.yLength);
        }
        result.add(onlySolution);
        return result;
    }

    public static boolean equal(String a, String b) {
        return a.charAt(0) == b.charAt(0);
    }

    public long getExactSubsequencesNumber() {
        if (!this.hasOneSolution) {
            return 0L;
        }
        this.setTotalPaths();
        Cell c = this.cellMatrix[this.xRegionStart][0];
        return c.totalPaths;
    }

    public ArrayList<ArrayList<Pair<String>>> getExactSubsequences() {
        if (!this.hasOneSolution) {
            return null;
        }
        Cell c = this.cellMatrix[this.xMax][this.yMax];
        ArrayList<ArrayList<Pair<String>>> result = new ArrayList<ArrayList<Pair<String>>>();
        c.addAllSubSequences(new ArrayList<Pair<String>>(), result);
        return result;
    }

    private void setTotalPaths() {
        Cell c = this.cellMatrix[this.xMax][this.yMax];
        long paths = 0L;
        int x = this.xRegionEnd;
        while (x >= this.xRegionStart) {
            c = this.cellMatrix[x][this.yMax];
            c.totalPaths = c.match ? ++paths : paths;
            --x;
        }
        int y = this.yMax - 1;
        while (y >= 0) {
            int x2 = this.xRegionEnd - 1;
            while (x2 >= 0) {
                c = this.cellMatrix[x2][y];
                c.totalPaths = this.cellMatrix[x2 + 1][y].totalPaths;
                if (c.match) {
                    c.totalPaths += this.cellMatrix[x2 + 1][y + 1].totalPaths;
                }
                --x2;
            }
            --y;
        }
    }

    public static ArrayList<ArrayList<Pair<String>>> getallExactSubsequences(String[] t1, String[] t2) {
        AllOrderedStringExactSubsequences O = new AllOrderedStringExactSubsequences(t1, t2);
        return O.getExactSubsequences();
    }

    public static ArrayList<ArrayList<Pair<String>>> getallExactSubsequencesBackupOnSimple(String[] t1, String[] t2) {
        AllOrderedStringExactSubsequences O = new AllOrderedStringExactSubsequences(t1, t2);
        long combinations = O.getExactSubsequencesNumber();
        if (combinations == 0L) {
            return null;
        }
        if (combinations > 1000L) {
            return O.getOneSolution();
        }
        return O.getExactSubsequences();
    }

    public static String[] getRandomString(int length, int choices) {
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            char c = (char)(firstChar + random.nextInt(choices));
            result[i] = "" + c + (i + 1);
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        Object[] a1 = new String[]{"A1", "C2", "C3", "A4", "A5", "C6", "A7", "A8", "C9"};
        Object[] a2 = new String[]{"C1"};
        System.out.println(Arrays.toString(a1));
        System.out.println(Arrays.toString(a2));
        ArrayList<ArrayList<Pair<String>>> result = AllOrderedStringExactSubsequences.getallExactSubsequencesBackupOnSimple((String[])a1, (String[])a2);
        System.out.println(result.size());
        for (ArrayList<Pair<String>> pList : result) {
            System.out.println(pList);
        }
    }

    protected class Cell {
        int x;
        int y;
        boolean match;
        boolean reachable;
        boolean leftReachable;
        boolean diagonalReachable;
        long totalPaths;

        protected Cell(int x, int y, boolean match) {
            this.x = x;
            this.y = y;
            if (match) {
                this.match = true;
                ++AllOrderedStringExactSubsequences.this.totalMatched;
            }
        }

        public void setLeftReachable() {
            this.leftReachable = true;
            this.reachable = true;
        }

        public void setDiagonalReachable() {
            this.diagonalReachable = true;
            this.reachable = true;
        }

        public void addAllSubSequences(ArrayList<Pair<String>> currentThread, ArrayList<ArrayList<Pair<String>>> result) {
            if (this.leftReachable && this.diagonalReachable) {
                ArrayList<Pair<String>> newThread = new ArrayList<Pair<String>>(currentThread);
                newThread.add(0, new Pair<String>(AllOrderedStringExactSubsequences.this.a1[this.x], AllOrderedStringExactSubsequences.this.a2[this.y]));
                AllOrderedStringExactSubsequences.this.cellMatrix[this.x - 1][this.y - 1].addAllSubSequences(newThread, result);
                AllOrderedStringExactSubsequences.this.cellMatrix[this.x - 1][this.y].addAllSubSequences(currentThread, result);
            } else if (this.y == 0) {
                if (this.leftReachable) {
                    if (this.match) {
                        ArrayList<Pair<String>> newThread = new ArrayList<Pair<String>>(currentThread);
                        AllOrderedStringExactSubsequences.this.cellMatrix[this.x - 1][this.y].addAllSubSequences(newThread, result);
                        currentThread.add(0, new Pair<String>(AllOrderedStringExactSubsequences.this.a1[this.x], AllOrderedStringExactSubsequences.this.a2[this.y]));
                        result.add(currentThread);
                    } else {
                        AllOrderedStringExactSubsequences.this.cellMatrix[this.x - 1][this.y].addAllSubSequences(currentThread, result);
                    }
                } else {
                    currentThread.add(0, new Pair<String>(AllOrderedStringExactSubsequences.this.a1[this.x], AllOrderedStringExactSubsequences.this.a2[this.y]));
                    result.add(currentThread);
                }
            } else if (this.leftReachable) {
                AllOrderedStringExactSubsequences.this.cellMatrix[this.x - 1][this.y].addAllSubSequences(currentThread, result);
            } else {
                currentThread.add(0, new Pair<String>(AllOrderedStringExactSubsequences.this.a1[this.x], AllOrderedStringExactSubsequences.this.a2[this.y]));
                AllOrderedStringExactSubsequences.this.cellMatrix[this.x - 1][this.y - 1].addAllSubSequences(currentThread, result);
            }
        }
    }
}

