from sklearn.feature_extraction.text import TfidfVectorizer
from sklearn.metrics.pairwise import cosine_similarity

def calculate_cosine_similarities(texts):
    vectorizer = TfidfVectorizer()
    tfidf_matrix = vectorizer.fit_transform(texts)
    n = len(texts)

    for i in range(n):
        for j in range(i+1, n):
            cosine_sim = cosine_similarity(tfidf_matrix[i:i+1], tfidf_matrix[j:j+1])[0][0]
            print(f"The cosine similarity between text {i+1} and text {j+1} is: {cosine_sim}")

texts = [
    "The absence of microaneurysms, intraretinal hemorrhages, and hard exudates, along with clear retinal vasculature, indicates {}.",
    "The presence of microaneurysms, mild retinal hemorrhages, mild cotton wool spots, and mild venous beading indicates {}.",
    "The presence of more prominent retinal hemorrhages, venous beading, moderate cotton wool spots, and intraretinal microvascular abnormalities indicates {}.",
    "The presence of more extensive areas of retinal hemorrhage, venous beading and loops, severe cotton wool spots, and neovascularization suggests {}.",
    "The presence of neovascularization, fibrous proliferation, vitreous hemorrhage, and tractional retinal detachment indicates {}."
        ]

calculate_cosine_similarities(texts)

