#!/bin/bash
set -e

CUDA_VISIBLE_DEVICES=0 python run.py \
    --data_dir ./data/Wikidata5M/wikidata5m_transductive/ \
    --device cuda \
    --AMP_enabled True \
    --task train \
    --num_workers 4 \
    --epochs 1 \
    --warmup 400 \
    --batch_size 1024 \
    --actual_batch_size 256 \
    --test_batch_size 64 \
    --finetune_t True \
    --tau 0.05 \
    --margin 0.02 \
    --lr 5e-5 \
    --weight_decay 1e-4 \
    --neighborhood_sample_K 32 \
    --r_prompt_len 4 \
    --extra_negative_sample_size 1024 \
    --m_decay 0.999 \
    --add_neighbor_name True \
    --queue_size 16384 \
    --e_max_length 64 \
    --hr_max_length 64 \
    --entity_embedding_method MLP \
    --hr_neighborhood True \
    --e_neighborhood True \
    --plm_name bert-base-uncased \
    --save_intermediate_files True \