#### Content

This code contains the top-down test case generation part of our HARM framework. We will open-source our more complete code (including scripts and code for multi-turn red teaming training, etc.) and instructions on GitHub.

#### Files

- **async_top_down_generation.py**: Code for generating test questions using the direct method.
- **top_down_generation_attack_vectors.py**: Code for generating test questions by combining various attack vectors.
- **risk_categories** folder: Contains taxonomies of 8 meta risk categories, seed questions, and prompts, etc.

#### Structure (Taking *Crime and Illegality* as an example)

- crime_attempts.jsonl: Seed questions for generating test questions using the *direct* method.
- prompt.txt: Prompt for generating test questions using the *direct* method.
- generated_questions.json: Test questions generated using the *direct* method.
- attack_vectors folder:
  - xx.txt: Prompt for xx attack vector.
  - xx.jsonl: Seed questions for xx attack vector.
- XX_questions.json: Test questions generated using the XX attack vector.