theory question_90_10

imports Main

begin

typedecl entity
typedecl event

consts
  Worker :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  Bent :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Three :: "entity ⇒ bool"
  Grass :: "entity ⇒ bool"
  Pulling :: "event ⇒ bool"

(* Explanation 1: Three workers are entities. *)
axiomatization where
  explanation_1: "∀x. Worker x ⟶ Entity x"

(* Explanation 2: The action of bending over is an event. *)
axiomatization where
  explanation_2: "∃e. Bent e"

(* Explanation 3: Three workers are bent over during a certain event. *)
axiomatization where
  explanation_3: "∃x e. Worker x ∧ Three x ∧ Bent e ∧ Agent e x"

theorem hypothesis:
  (* Premise: Three workers bent over pulling grass. *)
  assumes asm: "Worker x ∧ Three x ∧ Grass y ∧ Bent e1 ∧ Agent e1 x ∧ Pulling e2 ∧ Agent e2 x ∧ Patient e2 y"
  (* Hypothesis: Three workers bent over. *)
  shows "∃x. Worker x ∧ Three x ∧  Bent e ∧ Agent e x "
proof -
  from asm have "Worker x" "Three x" "Bent e1" "Agent e1 x" by blast+
  then show ?thesis using explanation_3 by blast
qed

end
